<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImportEntityIdsMappingResponse StructType
 * @subpackage Structs
 */
class GetImportEntityIdsMappingResponse extends AbstractStructBase
{
    /**
     * The EntityIdsMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOflonglong
     */
    public $EntityIdsMapping;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetImportEntityIdsMappingResponse
     * @uses GetImportEntityIdsMappingResponse::setEntityIdsMapping()
     * @uses GetImportEntityIdsMappingResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfKeyValuePairOflonglong $entityIdsMapping
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfKeyValuePairOflonglong $entityIdsMapping = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setEntityIdsMapping($entityIdsMapping)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get EntityIdsMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOflonglong|null
     */
    public function getEntityIdsMapping()
    {
        return isset($this->EntityIdsMapping) ? $this->EntityIdsMapping : null;
    }
    /**
     * Set EntityIdsMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOflonglong $entityIdsMapping
     * @return \StructType\GetImportEntityIdsMappingResponse
     */
    public function setEntityIdsMapping(\ArrayType\ArrayOfKeyValuePairOflonglong $entityIdsMapping = null)
    {
        if (is_null($entityIdsMapping) || (is_array($entityIdsMapping) && empty($entityIdsMapping))) {
            unset($this->EntityIdsMapping);
        } else {
            $this->EntityIdsMapping = $entityIdsMapping;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetImportEntityIdsMappingResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
