<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExperimentsByIdsResponse StructType
 * @subpackage Structs
 */
class GetExperimentsByIdsResponse extends AbstractStructBase
{
    /**
     * The Experiments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfExperiment
     */
    public $Experiments;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetExperimentsByIdsResponse
     * @uses GetExperimentsByIdsResponse::setExperiments()
     * @uses GetExperimentsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfExperiment $experiments
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfExperiment $experiments = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setExperiments($experiments)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Experiments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfExperiment|null
     */
    public function getExperiments()
    {
        return isset($this->Experiments) ? $this->Experiments : null;
    }
    /**
     * Set Experiments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfExperiment $experiments
     * @return \StructType\GetExperimentsByIdsResponse
     */
    public function setExperiments(\ArrayType\ArrayOfExperiment $experiments = null)
    {
        if (is_null($experiments) || (is_array($experiments) && empty($experiments))) {
            unset($this->Experiments);
        } else {
            $this->Experiments = $experiments;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetExperimentsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
