<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEditorialReasonsByIdsResponse StructType
 * @subpackage Structs
 */
class GetEditorialReasonsByIdsResponse extends AbstractStructBase
{
    /**
     * The EditorialReasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEditorialReasonCollection
     */
    public $EditorialReasons;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetEditorialReasonsByIdsResponse
     * @uses GetEditorialReasonsByIdsResponse::setEditorialReasons()
     * @uses GetEditorialReasonsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfEditorialReasonCollection $editorialReasons
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfEditorialReasonCollection $editorialReasons = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setEditorialReasons($editorialReasons)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get EditorialReasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEditorialReasonCollection|null
     */
    public function getEditorialReasons()
    {
        return isset($this->EditorialReasons) ? $this->EditorialReasons : null;
    }
    /**
     * Set EditorialReasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEditorialReasonCollection $editorialReasons
     * @return \StructType\GetEditorialReasonsByIdsResponse
     */
    public function setEditorialReasons(\ArrayType\ArrayOfEditorialReasonCollection $editorialReasons = null)
    {
        if (is_null($editorialReasons) || (is_array($editorialReasons) && empty($editorialReasons))) {
            unset($this->EditorialReasons);
        } else {
            $this->EditorialReasons = $editorialReasons;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetEditorialReasonsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
