<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCampaignsByIdsRequest StructType
 * @subpackage Structs
 */
class GetCampaignsByIdsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The CampaignIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $CampaignIds;
    /**
     * The CampaignType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CampaignType;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetCampaignsByIdsRequest
     * @uses GetCampaignsByIdsRequest::setAccountId()
     * @uses GetCampaignsByIdsRequest::setCampaignIds()
     * @uses GetCampaignsByIdsRequest::setCampaignType()
     * @uses GetCampaignsByIdsRequest::setReturnAdditionalFields()
     * @param int $accountId
     * @param \ArrayType\ArrayOflong $campaignIds
     * @param string[] $campaignType
     * @param string[] $returnAdditionalFields
     */
    public function __construct($accountId = null, \ArrayType\ArrayOflong $campaignIds = null, array $campaignType = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setAccountId($accountId)
            ->setCampaignIds($campaignIds)
            ->setCampaignType($campaignType)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetCampaignsByIdsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CampaignIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getCampaignIds()
    {
        return isset($this->CampaignIds) ? $this->CampaignIds : null;
    }
    /**
     * Set CampaignIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $campaignIds
     * @return \StructType\GetCampaignsByIdsRequest
     */
    public function setCampaignIds(\ArrayType\ArrayOflong $campaignIds = null)
    {
        if (is_null($campaignIds) || (is_array($campaignIds) && empty($campaignIds))) {
            unset($this->CampaignIds);
        } else {
            $this->CampaignIds = $campaignIds;
        }
        return $this;
    }
    /**
     * Get CampaignType value
     * @return string[]|null
     */
    public function getCampaignType()
    {
        return $this->CampaignType;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignTypeForArrayConstraintsFromSetCampaignType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCampaignsByIdsRequestCampaignTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignType::valueIsValid($getCampaignsByIdsRequestCampaignTypeItem)) {
                $invalidValues[] = is_object($getCampaignsByIdsRequestCampaignTypeItem) ? get_class($getCampaignsByIdsRequestCampaignTypeItem) : sprintf('%s(%s)', gettype($getCampaignsByIdsRequestCampaignTypeItem), var_export($getCampaignsByIdsRequestCampaignTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignType value
     * @uses \EnumType\CampaignType::valueIsValid()
     * @uses \EnumType\CampaignType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignType
     * @return \StructType\GetCampaignsByIdsRequest
     */
    public function setCampaignType(array $campaignType = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignTypeArrayErrorMessage = self::validateCampaignTypeForArrayConstraintsFromSetCampaignType($campaignType))) {
            throw new \InvalidArgumentException($campaignTypeArrayErrorMessage, __LINE__);
        }
        $this->CampaignType = is_array($campaignType) ? implode(' ', $campaignType) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCampaignsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignAdditionalField::valueIsValid($getCampaignsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getCampaignsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getCampaignsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getCampaignsByIdsRequestReturnAdditionalFieldsItem), var_export($getCampaignsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignAdditionalField::valueIsValid()
     * @uses \EnumType\CampaignAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetCampaignsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
