<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBudgetsByIdsResponse StructType
 * @subpackage Structs
 */
class GetBudgetsByIdsResponse extends AbstractStructBase
{
    /**
     * The Budgets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBudget
     */
    public $Budgets;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetBudgetsByIdsResponse
     * @uses GetBudgetsByIdsResponse::setBudgets()
     * @uses GetBudgetsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfBudget $budgets
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfBudget $budgets = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setBudgets($budgets)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Budgets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBudget|null
     */
    public function getBudgets()
    {
        return isset($this->Budgets) ? $this->Budgets : null;
    }
    /**
     * Set Budgets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBudget $budgets
     * @return \StructType\GetBudgetsByIdsResponse
     */
    public function setBudgets(\ArrayType\ArrayOfBudget $budgets = null)
    {
        if (is_null($budgets) || (is_array($budgets) && empty($budgets))) {
            unset($this->Budgets);
        } else {
            $this->Budgets = $budgets;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetBudgetsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
