<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBidStrategiesByIdsResponse StructType
 * @subpackage Structs
 */
class GetBidStrategiesByIdsResponse extends AbstractStructBase
{
    /**
     * The BidStrategies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBidStrategy
     */
    public $BidStrategies;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetBidStrategiesByIdsResponse
     * @uses GetBidStrategiesByIdsResponse::setBidStrategies()
     * @uses GetBidStrategiesByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfBidStrategy $bidStrategies
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfBidStrategy $bidStrategies = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setBidStrategies($bidStrategies)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get BidStrategies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBidStrategy|null
     */
    public function getBidStrategies()
    {
        return isset($this->BidStrategies) ? $this->BidStrategies : null;
    }
    /**
     * Set BidStrategies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBidStrategy $bidStrategies
     * @return \StructType\GetBidStrategiesByIdsResponse
     */
    public function setBidStrategies(\ArrayType\ArrayOfBidStrategy $bidStrategies = null)
    {
        if (is_null($bidStrategies) || (is_array($bidStrategies) && empty($bidStrategies))) {
            unset($this->BidStrategies);
        } else {
            $this->BidStrategies = $bidStrategies;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetBidStrategiesByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
