<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAudiencesByIdsRequest StructType
 * @subpackage Structs
 */
class GetAudiencesByIdsRequest extends AbstractStructBase
{
    /**
     * The AudienceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AudienceIds;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Type;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetAudiencesByIdsRequest
     * @uses GetAudiencesByIdsRequest::setAudienceIds()
     * @uses GetAudiencesByIdsRequest::setType()
     * @uses GetAudiencesByIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $audienceIds
     * @param string[] $type
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $audienceIds = null, array $type = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setAudienceIds($audienceIds)
            ->setType($type)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get AudienceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAudienceIds()
    {
        return isset($this->AudienceIds) ? $this->AudienceIds : null;
    }
    /**
     * Set AudienceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $audienceIds
     * @return \StructType\GetAudiencesByIdsRequest
     */
    public function setAudienceIds(\ArrayType\ArrayOflong $audienceIds = null)
    {
        if (is_null($audienceIds) || (is_array($audienceIds) && empty($audienceIds))) {
            unset($this->AudienceIds);
        } else {
            $this->AudienceIds = $audienceIds;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string[]|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAudiencesByIdsRequestTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AudienceType::valueIsValid($getAudiencesByIdsRequestTypeItem)) {
                $invalidValues[] = is_object($getAudiencesByIdsRequestTypeItem) ? get_class($getAudiencesByIdsRequestTypeItem) : sprintf('%s(%s)', gettype($getAudiencesByIdsRequestTypeItem), var_export($getAudiencesByIdsRequestTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AudienceType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AudienceType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * @uses \EnumType\AudienceType::valueIsValid()
     * @uses \EnumType\AudienceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \StructType\GetAudiencesByIdsRequest
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        $this->Type = is_array($type) ? implode(' ', $type) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAudiencesByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AudienceAdditionalField::valueIsValid($getAudiencesByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getAudiencesByIdsRequestReturnAdditionalFieldsItem) ? get_class($getAudiencesByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getAudiencesByIdsRequestReturnAdditionalFieldsItem), var_export($getAudiencesByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AudienceAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AudienceAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AudienceAdditionalField::valueIsValid()
     * @uses \EnumType\AudienceAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetAudiencesByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
