<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdsByIdsResponse StructType
 * @subpackage Structs
 */
class GetAdsByIdsResponse extends AbstractStructBase
{
    /**
     * The Ads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAd
     */
    public $Ads;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetAdsByIdsResponse
     * @uses GetAdsByIdsResponse::setAds()
     * @uses GetAdsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAd $ads
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAd $ads = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAds($ads)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Ads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAd|null
     */
    public function getAds()
    {
        return isset($this->Ads) ? $this->Ads : null;
    }
    /**
     * Set Ads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAd $ads
     * @return \StructType\GetAdsByIdsResponse
     */
    public function setAds(\ArrayType\ArrayOfAd $ads = null)
    {
        if (is_null($ads) || (is_array($ads) && empty($ads))) {
            unset($this->Ads);
        } else {
            $this->Ads = $ads;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetAdsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
