<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdGroupsByIdsRequest StructType
 * @subpackage Structs
 */
class GetAdGroupsByIdsRequest extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The AdGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdGroupIds;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetAdGroupsByIdsRequest
     * @uses GetAdGroupsByIdsRequest::setCampaignId()
     * @uses GetAdGroupsByIdsRequest::setAdGroupIds()
     * @uses GetAdGroupsByIdsRequest::setReturnAdditionalFields()
     * @param int $campaignId
     * @param \ArrayType\ArrayOflong $adGroupIds
     * @param string[] $returnAdditionalFields
     */
    public function __construct($campaignId = null, \ArrayType\ArrayOflong $adGroupIds = null, array $returnAdditionalFields = array())
    {
        $this
            ->setCampaignId($campaignId)
            ->setAdGroupIds($adGroupIds)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\GetAdGroupsByIdsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get AdGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdGroupIds()
    {
        return isset($this->AdGroupIds) ? $this->AdGroupIds : null;
    }
    /**
     * Set AdGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adGroupIds
     * @return \StructType\GetAdGroupsByIdsRequest
     */
    public function setAdGroupIds(\ArrayType\ArrayOflong $adGroupIds = null)
    {
        if (is_null($adGroupIds) || (is_array($adGroupIds) && empty($adGroupIds))) {
            unset($this->AdGroupIds);
        } else {
            $this->AdGroupIds = $adGroupIds;
        }
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdGroupsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupAdditionalField::valueIsValid($getAdGroupsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getAdGroupsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getAdGroupsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getAdGroupsByIdsRequestReturnAdditionalFieldsItem), var_export($getAdGroupsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupAdditionalField::valueIsValid()
     * @uses \EnumType\AdGroupAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetAdGroupsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
