<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdGroupCriterionsByIdsRequest StructType
 * @subpackage Structs
 */
class GetAdGroupCriterionsByIdsRequest extends AbstractStructBase
{
    /**
     * The AdGroupCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdGroupCriterionIds;
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The CriterionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CriterionType;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetAdGroupCriterionsByIdsRequest
     * @uses GetAdGroupCriterionsByIdsRequest::setAdGroupCriterionIds()
     * @uses GetAdGroupCriterionsByIdsRequest::setAdGroupId()
     * @uses GetAdGroupCriterionsByIdsRequest::setCriterionType()
     * @uses GetAdGroupCriterionsByIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $adGroupCriterionIds
     * @param int $adGroupId
     * @param string[] $criterionType
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $adGroupCriterionIds = null, $adGroupId = null, array $criterionType = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setAdGroupCriterionIds($adGroupCriterionIds)
            ->setAdGroupId($adGroupId)
            ->setCriterionType($criterionType)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get AdGroupCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdGroupCriterionIds()
    {
        return isset($this->AdGroupCriterionIds) ? $this->AdGroupCriterionIds : null;
    }
    /**
     * Set AdGroupCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adGroupCriterionIds
     * @return \StructType\GetAdGroupCriterionsByIdsRequest
     */
    public function setAdGroupCriterionIds(\ArrayType\ArrayOflong $adGroupCriterionIds = null)
    {
        if (is_null($adGroupCriterionIds) || (is_array($adGroupCriterionIds) && empty($adGroupCriterionIds))) {
            unset($this->AdGroupCriterionIds);
        } else {
            $this->AdGroupCriterionIds = $adGroupCriterionIds;
        }
        return $this;
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\GetAdGroupCriterionsByIdsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get CriterionType value
     * @return string[]|null
     */
    public function getCriterionType()
    {
        return $this->CriterionType;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionTypeForArrayConstraintsFromSetCriterionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdGroupCriterionsByIdsRequestCriterionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupCriterionType::valueIsValid($getAdGroupCriterionsByIdsRequestCriterionTypeItem)) {
                $invalidValues[] = is_object($getAdGroupCriterionsByIdsRequestCriterionTypeItem) ? get_class($getAdGroupCriterionsByIdsRequestCriterionTypeItem) : sprintf('%s(%s)', gettype($getAdGroupCriterionsByIdsRequestCriterionTypeItem), var_export($getAdGroupCriterionsByIdsRequestCriterionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupCriterionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupCriterionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CriterionType value
     * @uses \EnumType\AdGroupCriterionType::valueIsValid()
     * @uses \EnumType\AdGroupCriterionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $criterionType
     * @return \StructType\GetAdGroupCriterionsByIdsRequest
     */
    public function setCriterionType(array $criterionType = array())
    {
        // validation for constraint: list
        if ('' !== ($criterionTypeArrayErrorMessage = self::validateCriterionTypeForArrayConstraintsFromSetCriterionType($criterionType))) {
            throw new \InvalidArgumentException($criterionTypeArrayErrorMessage, __LINE__);
        }
        $this->CriterionType = is_array($criterionType) ? implode(' ', $criterionType) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CriterionAdditionalField::valueIsValid($getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem), var_export($getAdGroupCriterionsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CriterionAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CriterionAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CriterionAdditionalField::valueIsValid()
     * @uses \EnumType\CriterionAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetAdGroupCriterionsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
