<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdExtensionsByIdsResponse StructType
 * @subpackage Structs
 */
class GetAdExtensionsByIdsResponse extends AbstractStructBase
{
    /**
     * The AdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdExtension
     */
    public $AdExtensions;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetAdExtensionsByIdsResponse
     * @uses GetAdExtensionsByIdsResponse::setAdExtensions()
     * @uses GetAdExtensionsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAdExtension $adExtensions
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAdExtension $adExtensions = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdExtensions($adExtensions)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdExtension|null
     */
    public function getAdExtensions()
    {
        return isset($this->AdExtensions) ? $this->AdExtensions : null;
    }
    /**
     * Set AdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdExtension $adExtensions
     * @return \StructType\GetAdExtensionsByIdsResponse
     */
    public function setAdExtensions(\ArrayType\ArrayOfAdExtension $adExtensions = null)
    {
        if (is_null($adExtensions) || (is_array($adExtensions) && empty($adExtensions))) {
            unset($this->AdExtensions);
        } else {
            $this->AdExtensions = $adExtensions;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetAdExtensionsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
