<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdExtensionIdsByAccountIdRequest StructType
 * @subpackage Structs
 */
class GetAdExtensionIdsByAccountIdRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AdExtensionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AdExtensionType;
    /**
     * The AssociationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociationType;
    /**
     * Constructor method for GetAdExtensionIdsByAccountIdRequest
     * @uses GetAdExtensionIdsByAccountIdRequest::setAccountId()
     * @uses GetAdExtensionIdsByAccountIdRequest::setAdExtensionType()
     * @uses GetAdExtensionIdsByAccountIdRequest::setAssociationType()
     * @param int $accountId
     * @param string[] $adExtensionType
     * @param string $associationType
     */
    public function __construct($accountId = null, array $adExtensionType = array(), $associationType = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAdExtensionType($adExtensionType)
            ->setAssociationType($associationType);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetAdExtensionIdsByAccountIdRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AdExtensionType value
     * @return string[]|null
     */
    public function getAdExtensionType()
    {
        return $this->AdExtensionType;
    }
    /**
     * This method is responsible for validating the values passed to the setAdExtensionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdExtensionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdExtensionTypeForArrayConstraintsFromSetAdExtensionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdExtensionsTypeFilter::valueIsValid($getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem)) {
                $invalidValues[] = is_object($getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem) ? get_class($getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem) : sprintf('%s(%s)', gettype($getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem), var_export($getAdExtensionIdsByAccountIdRequestAdExtensionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdExtensionsTypeFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdExtensionsTypeFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdExtensionType value
     * @uses \EnumType\AdExtensionsTypeFilter::valueIsValid()
     * @uses \EnumType\AdExtensionsTypeFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adExtensionType
     * @return \StructType\GetAdExtensionIdsByAccountIdRequest
     */
    public function setAdExtensionType(array $adExtensionType = array())
    {
        // validation for constraint: list
        if ('' !== ($adExtensionTypeArrayErrorMessage = self::validateAdExtensionTypeForArrayConstraintsFromSetAdExtensionType($adExtensionType))) {
            throw new \InvalidArgumentException($adExtensionTypeArrayErrorMessage, __LINE__);
        }
        $this->AdExtensionType = is_array($adExtensionType) ? implode(' ', $adExtensionType) : null;
        return $this;
    }
    /**
     * Get AssociationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociationType()
    {
        return isset($this->AssociationType) ? $this->AssociationType : null;
    }
    /**
     * Set AssociationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AssociationType::valueIsValid()
     * @uses \EnumType\AssociationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $associationType
     * @return \StructType\GetAdExtensionIdsByAccountIdRequest
     */
    public function setAssociationType($associationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AssociationType::valueIsValid($associationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AssociationType', is_array($associationType) ? implode(', ', $associationType) : var_export($associationType, true), implode(', ', \EnumType\AssociationType::getValidValues())), __LINE__);
        }
        if (is_null($associationType) || (is_array($associationType) && empty($associationType))) {
            unset($this->AssociationType);
        } else {
            $this->AssociationType = $associationType;
        }
        return $this;
    }
}
