<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountPropertiesResponse StructType
 * @subpackage Structs
 */
class GetAccountPropertiesResponse extends AbstractStructBase
{
    /**
     * The AccountProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountProperty
     */
    public $AccountProperties;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetAccountPropertiesResponse
     * @uses GetAccountPropertiesResponse::setAccountProperties()
     * @uses GetAccountPropertiesResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAccountProperty $accountProperties
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAccountProperty $accountProperties = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAccountProperties($accountProperties)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AccountProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountProperty|null
     */
    public function getAccountProperties()
    {
        return isset($this->AccountProperties) ? $this->AccountProperties : null;
    }
    /**
     * Set AccountProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountProperty $accountProperties
     * @return \StructType\GetAccountPropertiesResponse
     */
    public function setAccountProperties(\ArrayType\ArrayOfAccountProperty $accountProperties = null)
    {
        if (is_null($accountProperties) || (is_array($accountProperties) && empty($accountProperties))) {
            unset($this->AccountProperties);
        } else {
            $this->AccountProperties = $accountProperties;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetAccountPropertiesResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
