<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoPoint StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeoPoint
 * @subpackage Structs
 */
class GeoPoint extends AbstractStructBase
{
    /**
     * The LatitudeInMicroDegrees
     * @var int
     */
    public $LatitudeInMicroDegrees;
    /**
     * The LongitudeInMicroDegrees
     * @var int
     */
    public $LongitudeInMicroDegrees;
    /**
     * Constructor method for GeoPoint
     * @uses GeoPoint::setLatitudeInMicroDegrees()
     * @uses GeoPoint::setLongitudeInMicroDegrees()
     * @param int $latitudeInMicroDegrees
     * @param int $longitudeInMicroDegrees
     */
    public function __construct($latitudeInMicroDegrees = null, $longitudeInMicroDegrees = null)
    {
        $this
            ->setLatitudeInMicroDegrees($latitudeInMicroDegrees)
            ->setLongitudeInMicroDegrees($longitudeInMicroDegrees);
    }
    /**
     * Get LatitudeInMicroDegrees value
     * @return int|null
     */
    public function getLatitudeInMicroDegrees()
    {
        return $this->LatitudeInMicroDegrees;
    }
    /**
     * Set LatitudeInMicroDegrees value
     * @param int $latitudeInMicroDegrees
     * @return \StructType\GeoPoint
     */
    public function setLatitudeInMicroDegrees($latitudeInMicroDegrees = null)
    {
        // validation for constraint: int
        if (!is_null($latitudeInMicroDegrees) && !(is_int($latitudeInMicroDegrees) || ctype_digit($latitudeInMicroDegrees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($latitudeInMicroDegrees, true), gettype($latitudeInMicroDegrees)), __LINE__);
        }
        $this->LatitudeInMicroDegrees = $latitudeInMicroDegrees;
        return $this;
    }
    /**
     * Get LongitudeInMicroDegrees value
     * @return int|null
     */
    public function getLongitudeInMicroDegrees()
    {
        return $this->LongitudeInMicroDegrees;
    }
    /**
     * Set LongitudeInMicroDegrees value
     * @param int $longitudeInMicroDegrees
     * @return \StructType\GeoPoint
     */
    public function setLongitudeInMicroDegrees($longitudeInMicroDegrees = null)
    {
        // validation for constraint: int
        if (!is_null($longitudeInMicroDegrees) && !(is_int($longitudeInMicroDegrees) || ctype_digit($longitudeInMicroDegrees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($longitudeInMicroDegrees, true), gettype($longitudeInMicroDegrees)), __LINE__);
        }
        $this->LongitudeInMicroDegrees = $longitudeInMicroDegrees;
        return $this;
    }
}
