<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Experiment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Experiment
 * @subpackage Structs
 */
class Experiment extends AbstractStructBase
{
    /**
     * The BaseCampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BaseCampaignId;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $EndDate;
    /**
     * The ExperimentCampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExperimentCampaignId;
    /**
     * The ExperimentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExperimentStatus;
    /**
     * The ExperimentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExperimentType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $StartDate;
    /**
     * The TrafficSplitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TrafficSplitPercent;
    /**
     * Constructor method for Experiment
     * @uses Experiment::setBaseCampaignId()
     * @uses Experiment::setEndDate()
     * @uses Experiment::setExperimentCampaignId()
     * @uses Experiment::setExperimentStatus()
     * @uses Experiment::setExperimentType()
     * @uses Experiment::setId()
     * @uses Experiment::setName()
     * @uses Experiment::setStartDate()
     * @uses Experiment::setTrafficSplitPercent()
     * @param int $baseCampaignId
     * @param \StructType\Date $endDate
     * @param int $experimentCampaignId
     * @param string $experimentStatus
     * @param string $experimentType
     * @param int $id
     * @param string $name
     * @param \StructType\Date $startDate
     * @param int $trafficSplitPercent
     */
    public function __construct($baseCampaignId = null, \StructType\Date $endDate = null, $experimentCampaignId = null, $experimentStatus = null, $experimentType = null, $id = null, $name = null, \StructType\Date $startDate = null, $trafficSplitPercent = null)
    {
        $this
            ->setBaseCampaignId($baseCampaignId)
            ->setEndDate($endDate)
            ->setExperimentCampaignId($experimentCampaignId)
            ->setExperimentStatus($experimentStatus)
            ->setExperimentType($experimentType)
            ->setId($id)
            ->setName($name)
            ->setStartDate($startDate)
            ->setTrafficSplitPercent($trafficSplitPercent);
    }
    /**
     * Get BaseCampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBaseCampaignId()
    {
        return isset($this->BaseCampaignId) ? $this->BaseCampaignId : null;
    }
    /**
     * Set BaseCampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $baseCampaignId
     * @return \StructType\Experiment
     */
    public function setBaseCampaignId($baseCampaignId = null)
    {
        // validation for constraint: int
        if (!is_null($baseCampaignId) && !(is_int($baseCampaignId) || ctype_digit($baseCampaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseCampaignId, true), gettype($baseCampaignId)), __LINE__);
        }
        if (is_null($baseCampaignId) || (is_array($baseCampaignId) && empty($baseCampaignId))) {
            unset($this->BaseCampaignId);
        } else {
            $this->BaseCampaignId = $baseCampaignId;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $endDate
     * @return \StructType\Experiment
     */
    public function setEndDate(\StructType\Date $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExperimentCampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExperimentCampaignId()
    {
        return isset($this->ExperimentCampaignId) ? $this->ExperimentCampaignId : null;
    }
    /**
     * Set ExperimentCampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $experimentCampaignId
     * @return \StructType\Experiment
     */
    public function setExperimentCampaignId($experimentCampaignId = null)
    {
        // validation for constraint: int
        if (!is_null($experimentCampaignId) && !(is_int($experimentCampaignId) || ctype_digit($experimentCampaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($experimentCampaignId, true), gettype($experimentCampaignId)), __LINE__);
        }
        if (is_null($experimentCampaignId) || (is_array($experimentCampaignId) && empty($experimentCampaignId))) {
            unset($this->ExperimentCampaignId);
        } else {
            $this->ExperimentCampaignId = $experimentCampaignId;
        }
        return $this;
    }
    /**
     * Get ExperimentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExperimentStatus()
    {
        return isset($this->ExperimentStatus) ? $this->ExperimentStatus : null;
    }
    /**
     * Set ExperimentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $experimentStatus
     * @return \StructType\Experiment
     */
    public function setExperimentStatus($experimentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($experimentStatus) && !is_string($experimentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($experimentStatus, true), gettype($experimentStatus)), __LINE__);
        }
        if (is_null($experimentStatus) || (is_array($experimentStatus) && empty($experimentStatus))) {
            unset($this->ExperimentStatus);
        } else {
            $this->ExperimentStatus = $experimentStatus;
        }
        return $this;
    }
    /**
     * Get ExperimentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExperimentType()
    {
        return isset($this->ExperimentType) ? $this->ExperimentType : null;
    }
    /**
     * Set ExperimentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $experimentType
     * @return \StructType\Experiment
     */
    public function setExperimentType($experimentType = null)
    {
        // validation for constraint: string
        if (!is_null($experimentType) && !is_string($experimentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($experimentType, true), gettype($experimentType)), __LINE__);
        }
        if (is_null($experimentType) || (is_array($experimentType) && empty($experimentType))) {
            unset($this->ExperimentType);
        } else {
            $this->ExperimentType = $experimentType;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Experiment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Experiment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $startDate
     * @return \StructType\Experiment
     */
    public function setStartDate(\StructType\Date $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TrafficSplitPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrafficSplitPercent()
    {
        return isset($this->TrafficSplitPercent) ? $this->TrafficSplitPercent : null;
    }
    /**
     * Set TrafficSplitPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trafficSplitPercent
     * @return \StructType\Experiment
     */
    public function setTrafficSplitPercent($trafficSplitPercent = null)
    {
        // validation for constraint: int
        if (!is_null($trafficSplitPercent) && !(is_int($trafficSplitPercent) || ctype_digit($trafficSplitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trafficSplitPercent, true), gettype($trafficSplitPercent)), __LINE__);
        }
        if (is_null($trafficSplitPercent) || (is_array($trafficSplitPercent) && empty($trafficSplitPercent))) {
            unset($this->TrafficSplitPercent);
        } else {
            $this->TrafficSplitPercent = $trafficSplitPercent;
        }
        return $this;
    }
}
