<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityIdToParentIdAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityIdToParentIdAssociation
 * @subpackage Structs
 */
class EntityIdToParentIdAssociation extends AbstractStructBase
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityId;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParentId;
    /**
     * Constructor method for EntityIdToParentIdAssociation
     * @uses EntityIdToParentIdAssociation::setEntityId()
     * @uses EntityIdToParentIdAssociation::setParentId()
     * @param int $entityId
     * @param int $parentId
     */
    public function __construct($entityId = null, $parentId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setParentId($parentId);
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\EntityIdToParentIdAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get ParentId value
     * @return int|null
     */
    public function getParentId()
    {
        return $this->ParentId;
    }
    /**
     * Set ParentId value
     * @param int $parentId
     * @return \StructType\EntityIdToParentIdAssociation
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !(is_int($parentId) || ctype_digit($parentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        $this->ParentId = $parentId;
        return $this;
    }
}
