<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceCriterion
 * @subpackage Structs
 */
class DeviceCriterion extends Criterion
{
    /**
     * The DeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * The OSName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OSName;
    /**
     * Constructor method for DeviceCriterion
     * @uses DeviceCriterion::setDeviceName()
     * @uses DeviceCriterion::setOSName()
     * @param string $deviceName
     * @param string $oSName
     */
    public function __construct($deviceName = null, $oSName = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setOSName($oSName);
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \StructType\DeviceCriterion
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
    /**
     * Get OSName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOSName()
    {
        return isset($this->OSName) ? $this->OSName : null;
    }
    /**
     * Set OSName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oSName
     * @return \StructType\DeviceCriterion
     */
    public function setOSName($oSName = null)
    {
        // validation for constraint: string
        if (!is_null($oSName) && !is_string($oSName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oSName, true), gettype($oSName)), __LINE__);
        }
        if (is_null($oSName) || (is_array($oSName) && empty($oSName))) {
            unset($this->OSName);
        } else {
            $this->OSName = $oSName;
        }
        return $this;
    }
}
