<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteSharedEntityAssociationsRequest StructType
 * @subpackage Structs
 */
class DeleteSharedEntityAssociationsRequest extends AbstractStructBase
{
    /**
     * The Associations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSharedEntityAssociation
     */
    public $Associations;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for DeleteSharedEntityAssociationsRequest
     * @uses DeleteSharedEntityAssociationsRequest::setAssociations()
     * @uses DeleteSharedEntityAssociationsRequest::setSharedEntityScope()
     * @param \ArrayType\ArrayOfSharedEntityAssociation $associations
     * @param string $sharedEntityScope
     */
    public function __construct(\ArrayType\ArrayOfSharedEntityAssociation $associations = null, $sharedEntityScope = null)
    {
        $this
            ->setAssociations($associations)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get Associations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSharedEntityAssociation|null
     */
    public function getAssociations()
    {
        return isset($this->Associations) ? $this->Associations : null;
    }
    /**
     * Set Associations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSharedEntityAssociation $associations
     * @return \StructType\DeleteSharedEntityAssociationsRequest
     */
    public function setAssociations(\ArrayType\ArrayOfSharedEntityAssociation $associations = null)
    {
        if (is_null($associations) || (is_array($associations) && empty($associations))) {
            unset($this->Associations);
        } else {
            $this->Associations = $associations;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\DeleteSharedEntityAssociationsRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
