<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteKeywordsRequest StructType
 * @subpackage Structs
 */
class DeleteKeywordsRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The KeywordIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $KeywordIds;
    /**
     * Constructor method for DeleteKeywordsRequest
     * @uses DeleteKeywordsRequest::setAdGroupId()
     * @uses DeleteKeywordsRequest::setKeywordIds()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOflong $keywordIds
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOflong $keywordIds = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setKeywordIds($keywordIds);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\DeleteKeywordsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get KeywordIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getKeywordIds()
    {
        return isset($this->KeywordIds) ? $this->KeywordIds : null;
    }
    /**
     * Set KeywordIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $keywordIds
     * @return \StructType\DeleteKeywordsRequest
     */
    public function setKeywordIds(\ArrayType\ArrayOflong $keywordIds = null)
    {
        if (is_null($keywordIds) || (is_array($keywordIds) && empty($keywordIds))) {
            unset($this->KeywordIds);
        } else {
            $this->KeywordIds = $keywordIds;
        }
        return $this;
    }
}
