<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteCampaignCriterionsRequest StructType
 * @subpackage Structs
 */
class DeleteCampaignCriterionsRequest extends AbstractStructBase
{
    /**
     * The CampaignCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $CampaignCriterionIds;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CriterionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CriterionType;
    /**
     * Constructor method for DeleteCampaignCriterionsRequest
     * @uses DeleteCampaignCriterionsRequest::setCampaignCriterionIds()
     * @uses DeleteCampaignCriterionsRequest::setCampaignId()
     * @uses DeleteCampaignCriterionsRequest::setCriterionType()
     * @param \ArrayType\ArrayOflong $campaignCriterionIds
     * @param int $campaignId
     * @param string[] $criterionType
     */
    public function __construct(\ArrayType\ArrayOflong $campaignCriterionIds = null, $campaignId = null, array $criterionType = array())
    {
        $this
            ->setCampaignCriterionIds($campaignCriterionIds)
            ->setCampaignId($campaignId)
            ->setCriterionType($criterionType);
    }
    /**
     * Get CampaignCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getCampaignCriterionIds()
    {
        return isset($this->CampaignCriterionIds) ? $this->CampaignCriterionIds : null;
    }
    /**
     * Set CampaignCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $campaignCriterionIds
     * @return \StructType\DeleteCampaignCriterionsRequest
     */
    public function setCampaignCriterionIds(\ArrayType\ArrayOflong $campaignCriterionIds = null)
    {
        if (is_null($campaignCriterionIds) || (is_array($campaignCriterionIds) && empty($campaignCriterionIds))) {
            unset($this->CampaignCriterionIds);
        } else {
            $this->CampaignCriterionIds = $campaignCriterionIds;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\DeleteCampaignCriterionsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CriterionType value
     * @return string[]|null
     */
    public function getCriterionType()
    {
        return $this->CriterionType;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionTypeForArrayConstraintsFromSetCriterionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteCampaignCriterionsRequestCriterionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignCriterionType::valueIsValid($deleteCampaignCriterionsRequestCriterionTypeItem)) {
                $invalidValues[] = is_object($deleteCampaignCriterionsRequestCriterionTypeItem) ? get_class($deleteCampaignCriterionsRequestCriterionTypeItem) : sprintf('%s(%s)', gettype($deleteCampaignCriterionsRequestCriterionTypeItem), var_export($deleteCampaignCriterionsRequestCriterionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignCriterionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignCriterionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CriterionType value
     * @uses \EnumType\CampaignCriterionType::valueIsValid()
     * @uses \EnumType\CampaignCriterionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $criterionType
     * @return \StructType\DeleteCampaignCriterionsRequest
     */
    public function setCriterionType(array $criterionType = array())
    {
        // validation for constraint: list
        if ('' !== ($criterionTypeArrayErrorMessage = self::validateCriterionTypeForArrayConstraintsFromSetCriterionType($criterionType))) {
            throw new \InvalidArgumentException($criterionTypeArrayErrorMessage, __LINE__);
        }
        $this->CriterionType = is_array($criterionType) ? implode(' ', $criterionType) : null;
        return $this;
    }
}
