<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteAdExtensionsRequest StructType
 * @subpackage Structs
 */
class DeleteAdExtensionsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AdExtensionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdExtensionIds;
    /**
     * Constructor method for DeleteAdExtensionsRequest
     * @uses DeleteAdExtensionsRequest::setAccountId()
     * @uses DeleteAdExtensionsRequest::setAdExtensionIds()
     * @param int $accountId
     * @param \ArrayType\ArrayOflong $adExtensionIds
     */
    public function __construct($accountId = null, \ArrayType\ArrayOflong $adExtensionIds = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAdExtensionIds($adExtensionIds);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\DeleteAdExtensionsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AdExtensionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdExtensionIds()
    {
        return isset($this->AdExtensionIds) ? $this->AdExtensionIds : null;
    }
    /**
     * Set AdExtensionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adExtensionIds
     * @return \StructType\DeleteAdExtensionsRequest
     */
    public function setAdExtensionIds(\ArrayType\ArrayOflong $adExtensionIds = null)
    {
        if (is_null($adExtensionIds) || (is_array($adExtensionIds) && empty($adExtensionIds))) {
            unset($this->AdExtensionIds);
        } else {
            $this->AdExtensionIds = $adExtensionIds;
        }
        return $this;
    }
}
