<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayTime StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DayTime
 * @subpackage Structs
 */
class DayTime extends AbstractStructBase
{
    /**
     * The Day
     * @var string
     */
    public $Day;
    /**
     * The EndHour
     * @var int
     */
    public $EndHour;
    /**
     * The EndMinute
     * @var string
     */
    public $EndMinute;
    /**
     * The StartHour
     * @var int
     */
    public $StartHour;
    /**
     * The StartMinute
     * @var string
     */
    public $StartMinute;
    /**
     * Constructor method for DayTime
     * @uses DayTime::setDay()
     * @uses DayTime::setEndHour()
     * @uses DayTime::setEndMinute()
     * @uses DayTime::setStartHour()
     * @uses DayTime::setStartMinute()
     * @param string $day
     * @param int $endHour
     * @param string $endMinute
     * @param int $startHour
     * @param string $startMinute
     */
    public function __construct($day = null, $endHour = null, $endMinute = null, $startHour = null, $startMinute = null)
    {
        $this
            ->setDay($day)
            ->setEndHour($endHour)
            ->setEndMinute($endMinute)
            ->setStartHour($startHour)
            ->setStartMinute($startMinute);
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @uses \EnumType\Day::valueIsValid()
     * @uses \EnumType\Day::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $day
     * @return \StructType\DayTime
     */
    public function setDay($day = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Day::valueIsValid($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Day', is_array($day) ? implode(', ', $day) : var_export($day, true), implode(', ', \EnumType\Day::getValidValues())), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get EndHour value
     * @return int|null
     */
    public function getEndHour()
    {
        return $this->EndHour;
    }
    /**
     * Set EndHour value
     * @param int $endHour
     * @return \StructType\DayTime
     */
    public function setEndHour($endHour = null)
    {
        // validation for constraint: int
        if (!is_null($endHour) && !(is_int($endHour) || ctype_digit($endHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endHour, true), gettype($endHour)), __LINE__);
        }
        $this->EndHour = $endHour;
        return $this;
    }
    /**
     * Get EndMinute value
     * @return string|null
     */
    public function getEndMinute()
    {
        return $this->EndMinute;
    }
    /**
     * Set EndMinute value
     * @uses \EnumType\Minute::valueIsValid()
     * @uses \EnumType\Minute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endMinute
     * @return \StructType\DayTime
     */
    public function setEndMinute($endMinute = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Minute::valueIsValid($endMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Minute', is_array($endMinute) ? implode(', ', $endMinute) : var_export($endMinute, true), implode(', ', \EnumType\Minute::getValidValues())), __LINE__);
        }
        $this->EndMinute = $endMinute;
        return $this;
    }
    /**
     * Get StartHour value
     * @return int|null
     */
    public function getStartHour()
    {
        return $this->StartHour;
    }
    /**
     * Set StartHour value
     * @param int $startHour
     * @return \StructType\DayTime
     */
    public function setStartHour($startHour = null)
    {
        // validation for constraint: int
        if (!is_null($startHour) && !(is_int($startHour) || ctype_digit($startHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startHour, true), gettype($startHour)), __LINE__);
        }
        $this->StartHour = $startHour;
        return $this;
    }
    /**
     * Get StartMinute value
     * @return string|null
     */
    public function getStartMinute()
    {
        return $this->StartMinute;
    }
    /**
     * Set StartMinute value
     * @uses \EnumType\Minute::valueIsValid()
     * @uses \EnumType\Minute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startMinute
     * @return \StructType\DayTime
     */
    public function setStartMinute($startMinute = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Minute::valueIsValid($startMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Minute', is_array($startMinute) ? implode(', ', $startMinute) : var_export($startMinute, true), implode(', ', \EnumType\Minute::getValidValues())), __LINE__);
        }
        $this->StartMinute = $startMinute;
        return $this;
    }
}
