<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerShare StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerShare
 * @subpackage Structs
 */
class CustomerShare extends AbstractStructBase
{
    /**
     * The CustomerAccountShares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomerAccountShare
     */
    public $CustomerAccountShares;
    /**
     * The OwnerCustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OwnerCustomerId;
    /**
     * Constructor method for CustomerShare
     * @uses CustomerShare::setCustomerAccountShares()
     * @uses CustomerShare::setOwnerCustomerId()
     * @param \ArrayType\ArrayOfCustomerAccountShare $customerAccountShares
     * @param int $ownerCustomerId
     */
    public function __construct(\ArrayType\ArrayOfCustomerAccountShare $customerAccountShares = null, $ownerCustomerId = null)
    {
        $this
            ->setCustomerAccountShares($customerAccountShares)
            ->setOwnerCustomerId($ownerCustomerId);
    }
    /**
     * Get CustomerAccountShares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomerAccountShare|null
     */
    public function getCustomerAccountShares()
    {
        return isset($this->CustomerAccountShares) ? $this->CustomerAccountShares : null;
    }
    /**
     * Set CustomerAccountShares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomerAccountShare $customerAccountShares
     * @return \StructType\CustomerShare
     */
    public function setCustomerAccountShares(\ArrayType\ArrayOfCustomerAccountShare $customerAccountShares = null)
    {
        if (is_null($customerAccountShares) || (is_array($customerAccountShares) && empty($customerAccountShares))) {
            unset($this->CustomerAccountShares);
        } else {
            $this->CustomerAccountShares = $customerAccountShares;
        }
        return $this;
    }
    /**
     * Get OwnerCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOwnerCustomerId()
    {
        return isset($this->OwnerCustomerId) ? $this->OwnerCustomerId : null;
    }
    /**
     * Set OwnerCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ownerCustomerId
     * @return \StructType\CustomerShare
     */
    public function setOwnerCustomerId($ownerCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($ownerCustomerId) && !(is_int($ownerCustomerId) || ctype_digit($ownerCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerCustomerId, true), gettype($ownerCustomerId)), __LINE__);
        }
        if (is_null($ownerCustomerId) || (is_array($ownerCustomerId) && empty($ownerCustomerId))) {
            unset($this->OwnerCustomerId);
        } else {
            $this->OwnerCustomerId = $ownerCustomerId;
        }
        return $this;
    }
}
