<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAccountShareAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerAccountShareAssociation
 * @subpackage Structs
 */
class CustomerAccountShareAssociation extends AbstractStructBase
{
    /**
     * The AssociationCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AssociationCount;
    /**
     * The UsageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsageType;
    /**
     * Constructor method for CustomerAccountShareAssociation
     * @uses CustomerAccountShareAssociation::setAssociationCount()
     * @uses CustomerAccountShareAssociation::setUsageType()
     * @param int $associationCount
     * @param string $usageType
     */
    public function __construct($associationCount = null, $usageType = null)
    {
        $this
            ->setAssociationCount($associationCount)
            ->setUsageType($usageType);
    }
    /**
     * Get AssociationCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAssociationCount()
    {
        return isset($this->AssociationCount) ? $this->AssociationCount : null;
    }
    /**
     * Set AssociationCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $associationCount
     * @return \StructType\CustomerAccountShareAssociation
     */
    public function setAssociationCount($associationCount = null)
    {
        // validation for constraint: int
        if (!is_null($associationCount) && !(is_int($associationCount) || ctype_digit($associationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associationCount, true), gettype($associationCount)), __LINE__);
        }
        if (is_null($associationCount) || (is_array($associationCount) && empty($associationCount))) {
            unset($this->AssociationCount);
        } else {
            $this->AssociationCount = $associationCount;
        }
        return $this;
    }
    /**
     * Get UsageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsageType()
    {
        return isset($this->UsageType) ? $this->UsageType : null;
    }
    /**
     * Set UsageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usageType
     * @return \StructType\CustomerAccountShareAssociation
     */
    public function setUsageType($usageType = null)
    {
        // validation for constraint: string
        if (!is_null($usageType) && !is_string($usageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageType, true), gettype($usageType)), __LINE__);
        }
        if (is_null($usageType) || (is_array($usageType) && empty($usageType))) {
            unset($this->UsageType);
        } else {
            $this->UsageType = $usageType;
        }
        return $this;
    }
}
