<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAccountShare StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerAccountShare
 * @subpackage Structs
 */
class CustomerAccountShare extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountId;
    /**
     * The Associations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomerAccountShareAssociation
     */
    public $Associations;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * Constructor method for CustomerAccountShare
     * @uses CustomerAccountShare::setAccountId()
     * @uses CustomerAccountShare::setAssociations()
     * @uses CustomerAccountShare::setCustomerId()
     * @param int $accountId
     * @param \ArrayType\ArrayOfCustomerAccountShareAssociation $associations
     * @param int $customerId
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfCustomerAccountShareAssociation $associations = null, $customerId = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAssociations($associations)
            ->setCustomerId($customerId);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountId
     * @return \StructType\CustomerAccountShare
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get Associations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomerAccountShareAssociation|null
     */
    public function getAssociations()
    {
        return isset($this->Associations) ? $this->Associations : null;
    }
    /**
     * Set Associations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomerAccountShareAssociation $associations
     * @return \StructType\CustomerAccountShare
     */
    public function setAssociations(\ArrayType\ArrayOfCustomerAccountShareAssociation $associations = null)
    {
        if (is_null($associations) || (is_array($associations) && empty($associations))) {
            unset($this->Associations);
        } else {
            $this->Associations = $associations;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $customerId
     * @return \StructType\CustomerAccountShare
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
}
