<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomEventsRule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomEventsRule
 * @subpackage Structs
 */
class CustomEventsRule extends RemarketingRule
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ActionOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionOperator;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The CategoryOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CategoryOperator;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LabelOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelOperator;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The ValueOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValueOperator;
    /**
     * Constructor method for CustomEventsRule
     * @uses CustomEventsRule::setAction()
     * @uses CustomEventsRule::setActionOperator()
     * @uses CustomEventsRule::setCategory()
     * @uses CustomEventsRule::setCategoryOperator()
     * @uses CustomEventsRule::setLabel()
     * @uses CustomEventsRule::setLabelOperator()
     * @uses CustomEventsRule::setValue()
     * @uses CustomEventsRule::setValueOperator()
     * @param string $action
     * @param string $actionOperator
     * @param string $category
     * @param string $categoryOperator
     * @param string $label
     * @param string $labelOperator
     * @param float $value
     * @param string $valueOperator
     */
    public function __construct($action = null, $actionOperator = null, $category = null, $categoryOperator = null, $label = null, $labelOperator = null, $value = null, $valueOperator = null)
    {
        $this
            ->setAction($action)
            ->setActionOperator($actionOperator)
            ->setCategory($category)
            ->setCategoryOperator($categoryOperator)
            ->setLabel($label)
            ->setLabelOperator($labelOperator)
            ->setValue($value)
            ->setValueOperator($valueOperator);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \StructType\CustomEventsRule
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ActionOperator value
     * @return string|null
     */
    public function getActionOperator()
    {
        return $this->ActionOperator;
    }
    /**
     * Set ActionOperator value
     * @uses \EnumType\StringOperator::valueIsValid()
     * @uses \EnumType\StringOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionOperator
     * @return \StructType\CustomEventsRule
     */
    public function setActionOperator($actionOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringOperator::valueIsValid($actionOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringOperator', is_array($actionOperator) ? implode(', ', $actionOperator) : var_export($actionOperator, true), implode(', ', \EnumType\StringOperator::getValidValues())), __LINE__);
        }
        $this->ActionOperator = $actionOperator;
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \StructType\CustomEventsRule
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get CategoryOperator value
     * @return string|null
     */
    public function getCategoryOperator()
    {
        return $this->CategoryOperator;
    }
    /**
     * Set CategoryOperator value
     * @uses \EnumType\StringOperator::valueIsValid()
     * @uses \EnumType\StringOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryOperator
     * @return \StructType\CustomEventsRule
     */
    public function setCategoryOperator($categoryOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringOperator::valueIsValid($categoryOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringOperator', is_array($categoryOperator) ? implode(', ', $categoryOperator) : var_export($categoryOperator, true), implode(', ', \EnumType\StringOperator::getValidValues())), __LINE__);
        }
        $this->CategoryOperator = $categoryOperator;
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \StructType\CustomEventsRule
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LabelOperator value
     * @return string|null
     */
    public function getLabelOperator()
    {
        return $this->LabelOperator;
    }
    /**
     * Set LabelOperator value
     * @uses \EnumType\StringOperator::valueIsValid()
     * @uses \EnumType\StringOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelOperator
     * @return \StructType\CustomEventsRule
     */
    public function setLabelOperator($labelOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringOperator::valueIsValid($labelOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringOperator', is_array($labelOperator) ? implode(', ', $labelOperator) : var_export($labelOperator, true), implode(', ', \EnumType\StringOperator::getValidValues())), __LINE__);
        }
        $this->LabelOperator = $labelOperator;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \StructType\CustomEventsRule
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get ValueOperator value
     * @return string|null
     */
    public function getValueOperator()
    {
        return $this->ValueOperator;
    }
    /**
     * Set ValueOperator value
     * @uses \EnumType\NumberOperator::valueIsValid()
     * @uses \EnumType\NumberOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueOperator
     * @return \StructType\CustomEventsRule
     */
    public function setValueOperator($valueOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NumberOperator::valueIsValid($valueOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NumberOperator', is_array($valueOperator) ? implode(', ', $valueOperator) : var_export($valueOperator, true), implode(', ', \EnumType\NumberOperator::getValidValues())), __LINE__);
        }
        $this->ValueOperator = $valueOperator;
        return $this;
    }
}
