<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionGoal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConversionGoal
 * @subpackage Structs
 */
class ConversionGoal extends AbstractStructBase
{
    /**
     * The ConversionWindowInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConversionWindowInMinutes;
    /**
     * The CountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountType;
    /**
     * The ExcludeFromBidding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcludeFromBidding;
    /**
     * The GoalCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoalCategory;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Revenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ConversionGoalRevenue
     */
    public $Revenue;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scope;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TagId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TagId;
    /**
     * The TrackingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingStatus;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The ViewThroughConversionWindowInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewThroughConversionWindowInMinutes;
    /**
     * Constructor method for ConversionGoal
     * @uses ConversionGoal::setConversionWindowInMinutes()
     * @uses ConversionGoal::setCountType()
     * @uses ConversionGoal::setExcludeFromBidding()
     * @uses ConversionGoal::setGoalCategory()
     * @uses ConversionGoal::setId()
     * @uses ConversionGoal::setName()
     * @uses ConversionGoal::setRevenue()
     * @uses ConversionGoal::setScope()
     * @uses ConversionGoal::setStatus()
     * @uses ConversionGoal::setTagId()
     * @uses ConversionGoal::setTrackingStatus()
     * @uses ConversionGoal::setType()
     * @uses ConversionGoal::setViewThroughConversionWindowInMinutes()
     * @param int $conversionWindowInMinutes
     * @param string $countType
     * @param bool $excludeFromBidding
     * @param string $goalCategory
     * @param int $id
     * @param string $name
     * @param \StructType\ConversionGoalRevenue $revenue
     * @param string $scope
     * @param string $status
     * @param int $tagId
     * @param string $trackingStatus
     * @param string[] $type
     * @param int $viewThroughConversionWindowInMinutes
     */
    public function __construct($conversionWindowInMinutes = null, $countType = null, $excludeFromBidding = null, $goalCategory = null, $id = null, $name = null, \StructType\ConversionGoalRevenue $revenue = null, $scope = null, $status = null, $tagId = null, $trackingStatus = null, array $type = array(), $viewThroughConversionWindowInMinutes = null)
    {
        $this
            ->setConversionWindowInMinutes($conversionWindowInMinutes)
            ->setCountType($countType)
            ->setExcludeFromBidding($excludeFromBidding)
            ->setGoalCategory($goalCategory)
            ->setId($id)
            ->setName($name)
            ->setRevenue($revenue)
            ->setScope($scope)
            ->setStatus($status)
            ->setTagId($tagId)
            ->setTrackingStatus($trackingStatus)
            ->setType($type)
            ->setViewThroughConversionWindowInMinutes($viewThroughConversionWindowInMinutes);
    }
    /**
     * Get ConversionWindowInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConversionWindowInMinutes()
    {
        return isset($this->ConversionWindowInMinutes) ? $this->ConversionWindowInMinutes : null;
    }
    /**
     * Set ConversionWindowInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $conversionWindowInMinutes
     * @return \StructType\ConversionGoal
     */
    public function setConversionWindowInMinutes($conversionWindowInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($conversionWindowInMinutes) && !(is_int($conversionWindowInMinutes) || ctype_digit($conversionWindowInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($conversionWindowInMinutes, true), gettype($conversionWindowInMinutes)), __LINE__);
        }
        if (is_null($conversionWindowInMinutes) || (is_array($conversionWindowInMinutes) && empty($conversionWindowInMinutes))) {
            unset($this->ConversionWindowInMinutes);
        } else {
            $this->ConversionWindowInMinutes = $conversionWindowInMinutes;
        }
        return $this;
    }
    /**
     * Get CountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountType()
    {
        return isset($this->CountType) ? $this->CountType : null;
    }
    /**
     * Set CountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalCountType::valueIsValid()
     * @uses \EnumType\ConversionGoalCountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countType
     * @return \StructType\ConversionGoal
     */
    public function setCountType($countType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConversionGoalCountType::valueIsValid($countType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalCountType', is_array($countType) ? implode(', ', $countType) : var_export($countType, true), implode(', ', \EnumType\ConversionGoalCountType::getValidValues())), __LINE__);
        }
        if (is_null($countType) || (is_array($countType) && empty($countType))) {
            unset($this->CountType);
        } else {
            $this->CountType = $countType;
        }
        return $this;
    }
    /**
     * Get ExcludeFromBidding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcludeFromBidding()
    {
        return isset($this->ExcludeFromBidding) ? $this->ExcludeFromBidding : null;
    }
    /**
     * Set ExcludeFromBidding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excludeFromBidding
     * @return \StructType\ConversionGoal
     */
    public function setExcludeFromBidding($excludeFromBidding = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromBidding) && !is_bool($excludeFromBidding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromBidding, true), gettype($excludeFromBidding)), __LINE__);
        }
        if (is_null($excludeFromBidding) || (is_array($excludeFromBidding) && empty($excludeFromBidding))) {
            unset($this->ExcludeFromBidding);
        } else {
            $this->ExcludeFromBidding = $excludeFromBidding;
        }
        return $this;
    }
    /**
     * Get GoalCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoalCategory()
    {
        return isset($this->GoalCategory) ? $this->GoalCategory : null;
    }
    /**
     * Set GoalCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalCategory::valueIsValid()
     * @uses \EnumType\ConversionGoalCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $goalCategory
     * @return \StructType\ConversionGoal
     */
    public function setGoalCategory($goalCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConversionGoalCategory::valueIsValid($goalCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalCategory', is_array($goalCategory) ? implode(', ', $goalCategory) : var_export($goalCategory, true), implode(', ', \EnumType\ConversionGoalCategory::getValidValues())), __LINE__);
        }
        if (is_null($goalCategory) || (is_array($goalCategory) && empty($goalCategory))) {
            unset($this->GoalCategory);
        } else {
            $this->GoalCategory = $goalCategory;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\ConversionGoal
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\ConversionGoal
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Revenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConversionGoalRevenue|null
     */
    public function getRevenue()
    {
        return isset($this->Revenue) ? $this->Revenue : null;
    }
    /**
     * Set Revenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ConversionGoalRevenue $revenue
     * @return \StructType\ConversionGoal
     */
    public function setRevenue(\StructType\ConversionGoalRevenue $revenue = null)
    {
        if (is_null($revenue) || (is_array($revenue) && empty($revenue))) {
            unset($this->Revenue);
        } else {
            $this->Revenue = $revenue;
        }
        return $this;
    }
    /**
     * Get Scope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScope()
    {
        return isset($this->Scope) ? $this->Scope : null;
    }
    /**
     * Set Scope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scope
     * @return \StructType\ConversionGoal
     */
    public function setScope($scope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($scope) ? implode(', ', $scope) : var_export($scope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($scope) || (is_array($scope) && empty($scope))) {
            unset($this->Scope);
        } else {
            $this->Scope = $scope;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalStatus::valueIsValid()
     * @uses \EnumType\ConversionGoalStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ConversionGoal
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConversionGoalStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ConversionGoalStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TagId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTagId()
    {
        return isset($this->TagId) ? $this->TagId : null;
    }
    /**
     * Set TagId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tagId
     * @return \StructType\ConversionGoal
     */
    public function setTagId($tagId = null)
    {
        // validation for constraint: int
        if (!is_null($tagId) && !(is_int($tagId) || ctype_digit($tagId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tagId, true), gettype($tagId)), __LINE__);
        }
        if (is_null($tagId) || (is_array($tagId) && empty($tagId))) {
            unset($this->TagId);
        } else {
            $this->TagId = $tagId;
        }
        return $this;
    }
    /**
     * Get TrackingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingStatus()
    {
        return isset($this->TrackingStatus) ? $this->TrackingStatus : null;
    }
    /**
     * Set TrackingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalTrackingStatus::valueIsValid()
     * @uses \EnumType\ConversionGoalTrackingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trackingStatus
     * @return \StructType\ConversionGoal
     */
    public function setTrackingStatus($trackingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConversionGoalTrackingStatus::valueIsValid($trackingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalTrackingStatus', is_array($trackingStatus) ? implode(', ', $trackingStatus) : var_export($trackingStatus, true), implode(', ', \EnumType\ConversionGoalTrackingStatus::getValidValues())), __LINE__);
        }
        if (is_null($trackingStatus) || (is_array($trackingStatus) && empty($trackingStatus))) {
            unset($this->TrackingStatus);
        } else {
            $this->TrackingStatus = $trackingStatus;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionGoalTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ConversionGoalType::valueIsValid($conversionGoalTypeItem)) {
                $invalidValues[] = is_object($conversionGoalTypeItem) ? get_class($conversionGoalTypeItem) : sprintf('%s(%s)', gettype($conversionGoalTypeItem), var_export($conversionGoalTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ConversionGoalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalType::valueIsValid()
     * @uses \EnumType\ConversionGoalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \StructType\ConversionGoal
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get ViewThroughConversionWindowInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewThroughConversionWindowInMinutes()
    {
        return isset($this->ViewThroughConversionWindowInMinutes) ? $this->ViewThroughConversionWindowInMinutes : null;
    }
    /**
     * Set ViewThroughConversionWindowInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewThroughConversionWindowInMinutes
     * @return \StructType\ConversionGoal
     */
    public function setViewThroughConversionWindowInMinutes($viewThroughConversionWindowInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($viewThroughConversionWindowInMinutes) && !(is_int($viewThroughConversionWindowInMinutes) || ctype_digit($viewThroughConversionWindowInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewThroughConversionWindowInMinutes, true), gettype($viewThroughConversionWindowInMinutes)), __LINE__);
        }
        if (is_null($viewThroughConversionWindowInMinutes) || (is_array($viewThroughConversionWindowInMinutes) && empty($viewThroughConversionWindowInMinutes))) {
            unset($this->ViewThroughConversionWindowInMinutes);
        } else {
            $this->ViewThroughConversionWindowInMinutes = $viewThroughConversionWindowInMinutes;
        }
        return $this;
    }
}
