<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoOpSetting StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CoOpSetting
 * @subpackage Structs
 */
class CoOpSetting extends Setting
{
    /**
     * The BidBoostValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BidBoostValue;
    /**
     * The BidMaxValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BidMaxValue;
    /**
     * The BidOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BidOption;
    /**
     * Constructor method for CoOpSetting
     * @uses CoOpSetting::setBidBoostValue()
     * @uses CoOpSetting::setBidMaxValue()
     * @uses CoOpSetting::setBidOption()
     * @param float $bidBoostValue
     * @param float $bidMaxValue
     * @param string $bidOption
     */
    public function __construct($bidBoostValue = null, $bidMaxValue = null, $bidOption = null)
    {
        $this
            ->setBidBoostValue($bidBoostValue)
            ->setBidMaxValue($bidMaxValue)
            ->setBidOption($bidOption);
    }
    /**
     * Get BidBoostValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBidBoostValue()
    {
        return isset($this->BidBoostValue) ? $this->BidBoostValue : null;
    }
    /**
     * Set BidBoostValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bidBoostValue
     * @return \StructType\CoOpSetting
     */
    public function setBidBoostValue($bidBoostValue = null)
    {
        // validation for constraint: float
        if (!is_null($bidBoostValue) && !(is_float($bidBoostValue) || is_numeric($bidBoostValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bidBoostValue, true), gettype($bidBoostValue)), __LINE__);
        }
        if (is_null($bidBoostValue) || (is_array($bidBoostValue) && empty($bidBoostValue))) {
            unset($this->BidBoostValue);
        } else {
            $this->BidBoostValue = $bidBoostValue;
        }
        return $this;
    }
    /**
     * Get BidMaxValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBidMaxValue()
    {
        return isset($this->BidMaxValue) ? $this->BidMaxValue : null;
    }
    /**
     * Set BidMaxValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bidMaxValue
     * @return \StructType\CoOpSetting
     */
    public function setBidMaxValue($bidMaxValue = null)
    {
        // validation for constraint: float
        if (!is_null($bidMaxValue) && !(is_float($bidMaxValue) || is_numeric($bidMaxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bidMaxValue, true), gettype($bidMaxValue)), __LINE__);
        }
        if (is_null($bidMaxValue) || (is_array($bidMaxValue) && empty($bidMaxValue))) {
            unset($this->BidMaxValue);
        } else {
            $this->BidMaxValue = $bidMaxValue;
        }
        return $this;
    }
    /**
     * Get BidOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBidOption()
    {
        return isset($this->BidOption) ? $this->BidOption : null;
    }
    /**
     * Set BidOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BidOption::valueIsValid()
     * @uses \EnumType\BidOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bidOption
     * @return \StructType\CoOpSetting
     */
    public function setBidOption($bidOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BidOption::valueIsValid($bidOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BidOption', is_array($bidOption) ? implode(', ', $bidOption) : var_export($bidOption, true), implode(', ', \EnumType\BidOption::getValidValues())), __LINE__);
        }
        if (is_null($bidOption) || (is_array($bidOption) && empty($bidOption))) {
            unset($this->BidOption);
        } else {
            $this->BidOption = $bidOption;
        }
        return $this;
    }
}
