<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashbackAdjustment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CashbackAdjustment
 * @subpackage Structs
 */
class CashbackAdjustment extends CriterionCashback
{
    /**
     * The CashbackPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CashbackPercent;
    /**
     * Constructor method for CashbackAdjustment
     * @uses CashbackAdjustment::setCashbackPercent()
     * @param float $cashbackPercent
     */
    public function __construct($cashbackPercent = null)
    {
        $this
            ->setCashbackPercent($cashbackPercent);
    }
    /**
     * Get CashbackPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCashbackPercent()
    {
        return isset($this->CashbackPercent) ? $this->CashbackPercent : null;
    }
    /**
     * Set CashbackPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cashbackPercent
     * @return \StructType\CashbackAdjustment
     */
    public function setCashbackPercent($cashbackPercent = null)
    {
        // validation for constraint: float
        if (!is_null($cashbackPercent) && !(is_float($cashbackPercent) || is_numeric($cashbackPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashbackPercent, true), gettype($cashbackPercent)), __LINE__);
        }
        if (is_null($cashbackPercent) || (is_array($cashbackPercent) && empty($cashbackPercent))) {
            unset($this->CashbackPercent);
        } else {
            $this->CashbackPercent = $cashbackPercent;
        }
        return $this;
    }
}
