<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignSize StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignSize
 * @subpackage Structs
 */
class CampaignSize extends AbstractStructBase
{
    /**
     * The CampaignId
     * @var int
     */
    public $CampaignId;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Size;
    /**
     * Constructor method for CampaignSize
     * @uses CampaignSize::setCampaignId()
     * @uses CampaignSize::setSize()
     * @param int $campaignId
     * @param int $size
     */
    public function __construct($campaignId = null, $size = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setSize($size);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\CampaignSize
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get Size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param int $size
     * @return \StructType\CampaignSize
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
}
