<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignNegativeSites StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignNegativeSites
 * @subpackage Structs
 */
class CampaignNegativeSites extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The NegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $NegativeSites;
    /**
     * Constructor method for CampaignNegativeSites
     * @uses CampaignNegativeSites::setCampaignId()
     * @uses CampaignNegativeSites::setNegativeSites()
     * @param int $campaignId
     * @param \ArrayType\ArrayOfstring $negativeSites
     */
    public function __construct($campaignId = null, \ArrayType\ArrayOfstring $negativeSites = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setNegativeSites($negativeSites);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\CampaignNegativeSites
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get NegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getNegativeSites()
    {
        return isset($this->NegativeSites) ? $this->NegativeSites : null;
    }
    /**
     * Set NegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $negativeSites
     * @return \StructType\CampaignNegativeSites
     */
    public function setNegativeSites(\ArrayType\ArrayOfstring $negativeSites = null)
    {
        if (is_null($negativeSites) || (is_array($negativeSites) && empty($negativeSites))) {
            unset($this->NegativeSites);
        } else {
            $this->NegativeSites = $negativeSites;
        }
        return $this;
    }
}
