<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Campaign
 * @subpackage Structs
 */
class Campaign extends AbstractStructBase
{
    /**
     * The AudienceAdsBidAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AudienceAdsBidAdjustment;
    /**
     * The BiddingScheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BiddingScheme
     */
    public $BiddingScheme;
    /**
     * The BudgetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BudgetType;
    /**
     * The DailyBudget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DailyBudget;
    /**
     * The ExperimentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExperimentId;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The MultimediaAdsBidAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MultimediaAdsBidAdjustment;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * The CampaignType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignType;
    /**
     * The Settings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSetting
     */
    public $Settings;
    /**
     * The BudgetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BudgetId;
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Languages;
    /**
     * The AdScheduleUseSearcherTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AdScheduleUseSearcherTimeZone;
    /**
     * The BidStrategyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BidStrategyId;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setAudienceAdsBidAdjustment()
     * @uses Campaign::setBiddingScheme()
     * @uses Campaign::setBudgetType()
     * @uses Campaign::setDailyBudget()
     * @uses Campaign::setExperimentId()
     * @uses Campaign::setFinalUrlSuffix()
     * @uses Campaign::setForwardCompatibilityMap()
     * @uses Campaign::setId()
     * @uses Campaign::setMultimediaAdsBidAdjustment()
     * @uses Campaign::setName()
     * @uses Campaign::setStatus()
     * @uses Campaign::setSubType()
     * @uses Campaign::setTimeZone()
     * @uses Campaign::setTrackingUrlTemplate()
     * @uses Campaign::setUrlCustomParameters()
     * @uses Campaign::setCampaignType()
     * @uses Campaign::setSettings()
     * @uses Campaign::setBudgetId()
     * @uses Campaign::setLanguages()
     * @uses Campaign::setAdScheduleUseSearcherTimeZone()
     * @uses Campaign::setBidStrategyId()
     * @param int $audienceAdsBidAdjustment
     * @param \StructType\BiddingScheme $biddingScheme
     * @param string $budgetType
     * @param float $dailyBudget
     * @param int $experimentId
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param int $multimediaAdsBidAdjustment
     * @param string $name
     * @param string $status
     * @param string $subType
     * @param string $timeZone
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     * @param string[] $campaignType
     * @param \ArrayType\ArrayOfSetting $settings
     * @param int $budgetId
     * @param \ArrayType\ArrayOfstring $languages
     * @param bool $adScheduleUseSearcherTimeZone
     * @param int $bidStrategyId
     */
    public function __construct($audienceAdsBidAdjustment = null, \StructType\BiddingScheme $biddingScheme = null, $budgetType = null, $dailyBudget = null, $experimentId = null, $finalUrlSuffix = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, $multimediaAdsBidAdjustment = null, $name = null, $status = null, $subType = null, $timeZone = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null, array $campaignType = array(), \ArrayType\ArrayOfSetting $settings = null, $budgetId = null, \ArrayType\ArrayOfstring $languages = null, $adScheduleUseSearcherTimeZone = null, $bidStrategyId = null)
    {
        $this
            ->setAudienceAdsBidAdjustment($audienceAdsBidAdjustment)
            ->setBiddingScheme($biddingScheme)
            ->setBudgetType($budgetType)
            ->setDailyBudget($dailyBudget)
            ->setExperimentId($experimentId)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setMultimediaAdsBidAdjustment($multimediaAdsBidAdjustment)
            ->setName($name)
            ->setStatus($status)
            ->setSubType($subType)
            ->setTimeZone($timeZone)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters)
            ->setCampaignType($campaignType)
            ->setSettings($settings)
            ->setBudgetId($budgetId)
            ->setLanguages($languages)
            ->setAdScheduleUseSearcherTimeZone($adScheduleUseSearcherTimeZone)
            ->setBidStrategyId($bidStrategyId);
    }
    /**
     * Get AudienceAdsBidAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAudienceAdsBidAdjustment()
    {
        return isset($this->AudienceAdsBidAdjustment) ? $this->AudienceAdsBidAdjustment : null;
    }
    /**
     * Set AudienceAdsBidAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $audienceAdsBidAdjustment
     * @return \StructType\Campaign
     */
    public function setAudienceAdsBidAdjustment($audienceAdsBidAdjustment = null)
    {
        // validation for constraint: int
        if (!is_null($audienceAdsBidAdjustment) && !(is_int($audienceAdsBidAdjustment) || ctype_digit($audienceAdsBidAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($audienceAdsBidAdjustment, true), gettype($audienceAdsBidAdjustment)), __LINE__);
        }
        if (is_null($audienceAdsBidAdjustment) || (is_array($audienceAdsBidAdjustment) && empty($audienceAdsBidAdjustment))) {
            unset($this->AudienceAdsBidAdjustment);
        } else {
            $this->AudienceAdsBidAdjustment = $audienceAdsBidAdjustment;
        }
        return $this;
    }
    /**
     * Get BiddingScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BiddingScheme|null
     */
    public function getBiddingScheme()
    {
        return isset($this->BiddingScheme) ? $this->BiddingScheme : null;
    }
    /**
     * Set BiddingScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BiddingScheme $biddingScheme
     * @return \StructType\Campaign
     */
    public function setBiddingScheme(\StructType\BiddingScheme $biddingScheme = null)
    {
        if (is_null($biddingScheme) || (is_array($biddingScheme) && empty($biddingScheme))) {
            unset($this->BiddingScheme);
        } else {
            $this->BiddingScheme = $biddingScheme;
        }
        return $this;
    }
    /**
     * Get BudgetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBudgetType()
    {
        return isset($this->BudgetType) ? $this->BudgetType : null;
    }
    /**
     * Set BudgetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BudgetLimitType::valueIsValid()
     * @uses \EnumType\BudgetLimitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $budgetType
     * @return \StructType\Campaign
     */
    public function setBudgetType($budgetType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BudgetLimitType::valueIsValid($budgetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BudgetLimitType', is_array($budgetType) ? implode(', ', $budgetType) : var_export($budgetType, true), implode(', ', \EnumType\BudgetLimitType::getValidValues())), __LINE__);
        }
        if (is_null($budgetType) || (is_array($budgetType) && empty($budgetType))) {
            unset($this->BudgetType);
        } else {
            $this->BudgetType = $budgetType;
        }
        return $this;
    }
    /**
     * Get DailyBudget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDailyBudget()
    {
        return isset($this->DailyBudget) ? $this->DailyBudget : null;
    }
    /**
     * Set DailyBudget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dailyBudget
     * @return \StructType\Campaign
     */
    public function setDailyBudget($dailyBudget = null)
    {
        // validation for constraint: float
        if (!is_null($dailyBudget) && !(is_float($dailyBudget) || is_numeric($dailyBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyBudget, true), gettype($dailyBudget)), __LINE__);
        }
        if (is_null($dailyBudget) || (is_array($dailyBudget) && empty($dailyBudget))) {
            unset($this->DailyBudget);
        } else {
            $this->DailyBudget = $dailyBudget;
        }
        return $this;
    }
    /**
     * Get ExperimentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExperimentId()
    {
        return isset($this->ExperimentId) ? $this->ExperimentId : null;
    }
    /**
     * Set ExperimentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $experimentId
     * @return \StructType\Campaign
     */
    public function setExperimentId($experimentId = null)
    {
        // validation for constraint: int
        if (!is_null($experimentId) && !(is_int($experimentId) || ctype_digit($experimentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($experimentId, true), gettype($experimentId)), __LINE__);
        }
        if (is_null($experimentId) || (is_array($experimentId) && empty($experimentId))) {
            unset($this->ExperimentId);
        } else {
            $this->ExperimentId = $experimentId;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\Campaign
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\Campaign
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Campaign
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MultimediaAdsBidAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMultimediaAdsBidAdjustment()
    {
        return isset($this->MultimediaAdsBidAdjustment) ? $this->MultimediaAdsBidAdjustment : null;
    }
    /**
     * Set MultimediaAdsBidAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $multimediaAdsBidAdjustment
     * @return \StructType\Campaign
     */
    public function setMultimediaAdsBidAdjustment($multimediaAdsBidAdjustment = null)
    {
        // validation for constraint: int
        if (!is_null($multimediaAdsBidAdjustment) && !(is_int($multimediaAdsBidAdjustment) || ctype_digit($multimediaAdsBidAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($multimediaAdsBidAdjustment, true), gettype($multimediaAdsBidAdjustment)), __LINE__);
        }
        if (is_null($multimediaAdsBidAdjustment) || (is_array($multimediaAdsBidAdjustment) && empty($multimediaAdsBidAdjustment))) {
            unset($this->MultimediaAdsBidAdjustment);
        } else {
            $this->MultimediaAdsBidAdjustment = $multimediaAdsBidAdjustment;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Campaign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatus::valueIsValid()
     * @uses \EnumType\CampaignStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Campaign
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\CampaignStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subType
     * @return \StructType\Campaign
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subType, true), gettype($subType)), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \StructType\Campaign
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\Campaign
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\Campaign
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
    /**
     * Get CampaignType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignType()
    {
        return isset($this->CampaignType) ? $this->CampaignType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignTypeForArrayConstraintsFromSetCampaignType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignCampaignTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignType::valueIsValid($campaignCampaignTypeItem)) {
                $invalidValues[] = is_object($campaignCampaignTypeItem) ? get_class($campaignCampaignTypeItem) : sprintf('%s(%s)', gettype($campaignCampaignTypeItem), var_export($campaignCampaignTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignType::valueIsValid()
     * @uses \EnumType\CampaignType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignType
     * @return \StructType\Campaign
     */
    public function setCampaignType(array $campaignType = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignTypeArrayErrorMessage = self::validateCampaignTypeForArrayConstraintsFromSetCampaignType($campaignType))) {
            throw new \InvalidArgumentException($campaignTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignType) || (is_array($campaignType) && empty($campaignType))) {
            unset($this->CampaignType);
        } else {
            $this->CampaignType = is_array($campaignType) ? implode(' ', $campaignType) : null;
        }
        return $this;
    }
    /**
     * Get Settings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSetting|null
     */
    public function getSettings()
    {
        return isset($this->Settings) ? $this->Settings : null;
    }
    /**
     * Set Settings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSetting $settings
     * @return \StructType\Campaign
     */
    public function setSettings(\ArrayType\ArrayOfSetting $settings = null)
    {
        if (is_null($settings) || (is_array($settings) && empty($settings))) {
            unset($this->Settings);
        } else {
            $this->Settings = $settings;
        }
        return $this;
    }
    /**
     * Get BudgetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBudgetId()
    {
        return isset($this->BudgetId) ? $this->BudgetId : null;
    }
    /**
     * Set BudgetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $budgetId
     * @return \StructType\Campaign
     */
    public function setBudgetId($budgetId = null)
    {
        // validation for constraint: int
        if (!is_null($budgetId) && !(is_int($budgetId) || ctype_digit($budgetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($budgetId, true), gettype($budgetId)), __LINE__);
        }
        if (is_null($budgetId) || (is_array($budgetId) && empty($budgetId))) {
            unset($this->BudgetId);
        } else {
            $this->BudgetId = $budgetId;
        }
        return $this;
    }
    /**
     * Get Languages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getLanguages()
    {
        return isset($this->Languages) ? $this->Languages : null;
    }
    /**
     * Set Languages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $languages
     * @return \StructType\Campaign
     */
    public function setLanguages(\ArrayType\ArrayOfstring $languages = null)
    {
        if (is_null($languages) || (is_array($languages) && empty($languages))) {
            unset($this->Languages);
        } else {
            $this->Languages = $languages;
        }
        return $this;
    }
    /**
     * Get AdScheduleUseSearcherTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAdScheduleUseSearcherTimeZone()
    {
        return isset($this->AdScheduleUseSearcherTimeZone) ? $this->AdScheduleUseSearcherTimeZone : null;
    }
    /**
     * Set AdScheduleUseSearcherTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $adScheduleUseSearcherTimeZone
     * @return \StructType\Campaign
     */
    public function setAdScheduleUseSearcherTimeZone($adScheduleUseSearcherTimeZone = null)
    {
        // validation for constraint: boolean
        if (!is_null($adScheduleUseSearcherTimeZone) && !is_bool($adScheduleUseSearcherTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($adScheduleUseSearcherTimeZone, true), gettype($adScheduleUseSearcherTimeZone)), __LINE__);
        }
        if (is_null($adScheduleUseSearcherTimeZone) || (is_array($adScheduleUseSearcherTimeZone) && empty($adScheduleUseSearcherTimeZone))) {
            unset($this->AdScheduleUseSearcherTimeZone);
        } else {
            $this->AdScheduleUseSearcherTimeZone = $adScheduleUseSearcherTimeZone;
        }
        return $this;
    }
    /**
     * Get BidStrategyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBidStrategyId()
    {
        return isset($this->BidStrategyId) ? $this->BidStrategyId : null;
    }
    /**
     * Set BidStrategyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bidStrategyId
     * @return \StructType\Campaign
     */
    public function setBidStrategyId($bidStrategyId = null)
    {
        // validation for constraint: int
        if (!is_null($bidStrategyId) && !(is_int($bidStrategyId) || ctype_digit($bidStrategyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bidStrategyId, true), gettype($bidStrategyId)), __LINE__);
        }
        if (is_null($bidStrategyId) || (is_array($bidStrategyId) && empty($bidStrategyId))) {
            unset($this->BidStrategyId);
        } else {
            $this->BidStrategyId = $bidStrategyId;
        }
        return $this;
    }
}
