<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Budget StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Budget
 * @subpackage Structs
 */
class Budget extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The AssociationCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AssociationCount;
    /**
     * The BudgetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BudgetType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Budget
     * @uses Budget::setAmount()
     * @uses Budget::setAssociationCount()
     * @uses Budget::setBudgetType()
     * @uses Budget::setId()
     * @uses Budget::setName()
     * @param float $amount
     * @param int $associationCount
     * @param string $budgetType
     * @param int $id
     * @param string $name
     */
    public function __construct($amount = null, $associationCount = null, $budgetType = null, $id = null, $name = null)
    {
        $this
            ->setAmount($amount)
            ->setAssociationCount($associationCount)
            ->setBudgetType($budgetType)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \StructType\Budget
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AssociationCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAssociationCount()
    {
        return isset($this->AssociationCount) ? $this->AssociationCount : null;
    }
    /**
     * Set AssociationCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $associationCount
     * @return \StructType\Budget
     */
    public function setAssociationCount($associationCount = null)
    {
        // validation for constraint: int
        if (!is_null($associationCount) && !(is_int($associationCount) || ctype_digit($associationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associationCount, true), gettype($associationCount)), __LINE__);
        }
        if (is_null($associationCount) || (is_array($associationCount) && empty($associationCount))) {
            unset($this->AssociationCount);
        } else {
            $this->AssociationCount = $associationCount;
        }
        return $this;
    }
    /**
     * Get BudgetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBudgetType()
    {
        return isset($this->BudgetType) ? $this->BudgetType : null;
    }
    /**
     * Set BudgetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BudgetLimitType::valueIsValid()
     * @uses \EnumType\BudgetLimitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $budgetType
     * @return \StructType\Budget
     */
    public function setBudgetType($budgetType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BudgetLimitType::valueIsValid($budgetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BudgetLimitType', is_array($budgetType) ? implode(', ', $budgetType) : var_export($budgetType, true), implode(', ', \EnumType\BudgetLimitType::getValidValues())), __LINE__);
        }
        if (is_null($budgetType) || (is_array($budgetType) && empty($budgetType))) {
            unset($this->BudgetType);
        } else {
            $this->BudgetType = $budgetType;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Budget
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Budget
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
