<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BiddableAdGroupCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BiddableAdGroupCriterion
 * @subpackage Structs
 */
class BiddableAdGroupCriterion extends AdGroupCriterion
{
    /**
     * The CriterionBid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CriterionBid
     */
    public $CriterionBid;
    /**
     * The DestinationUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationUrl;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditorialStatus;
    /**
     * The FinalAppUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAppUrl
     */
    public $FinalAppUrls;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * The CriterionCashback
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CriterionCashback
     */
    public $CriterionCashback;
    /**
     * Constructor method for BiddableAdGroupCriterion
     * @uses BiddableAdGroupCriterion::setCriterionBid()
     * @uses BiddableAdGroupCriterion::setDestinationUrl()
     * @uses BiddableAdGroupCriterion::setEditorialStatus()
     * @uses BiddableAdGroupCriterion::setFinalAppUrls()
     * @uses BiddableAdGroupCriterion::setFinalMobileUrls()
     * @uses BiddableAdGroupCriterion::setFinalUrlSuffix()
     * @uses BiddableAdGroupCriterion::setFinalUrls()
     * @uses BiddableAdGroupCriterion::setTrackingUrlTemplate()
     * @uses BiddableAdGroupCriterion::setUrlCustomParameters()
     * @uses BiddableAdGroupCriterion::setCriterionCashback()
     * @param \StructType\CriterionBid $criterionBid
     * @param string $destinationUrl
     * @param string $editorialStatus
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     * @param \StructType\CriterionCashback $criterionCashback
     */
    public function __construct(\StructType\CriterionBid $criterionBid = null, $destinationUrl = null, $editorialStatus = null, \ArrayType\ArrayOfAppUrl $finalAppUrls = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, $finalUrlSuffix = null, \ArrayType\ArrayOfstring $finalUrls = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null, \StructType\CriterionCashback $criterionCashback = null)
    {
        $this
            ->setCriterionBid($criterionBid)
            ->setDestinationUrl($destinationUrl)
            ->setEditorialStatus($editorialStatus)
            ->setFinalAppUrls($finalAppUrls)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setFinalUrls($finalUrls)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters)
            ->setCriterionCashback($criterionCashback);
    }
    /**
     * Get CriterionBid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CriterionBid|null
     */
    public function getCriterionBid()
    {
        return isset($this->CriterionBid) ? $this->CriterionBid : null;
    }
    /**
     * Set CriterionBid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CriterionBid $criterionBid
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setCriterionBid(\StructType\CriterionBid $criterionBid = null)
    {
        if (is_null($criterionBid) || (is_array($criterionBid) && empty($criterionBid))) {
            unset($this->CriterionBid);
        } else {
            $this->CriterionBid = $criterionBid;
        }
        return $this;
    }
    /**
     * Get DestinationUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationUrl()
    {
        return isset($this->DestinationUrl) ? $this->DestinationUrl : null;
    }
    /**
     * Set DestinationUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationUrl
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setDestinationUrl($destinationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($destinationUrl) && !is_string($destinationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationUrl, true), gettype($destinationUrl)), __LINE__);
        }
        if (is_null($destinationUrl) || (is_array($destinationUrl) && empty($destinationUrl))) {
            unset($this->DestinationUrl);
        } else {
            $this->DestinationUrl = $destinationUrl;
        }
        return $this;
    }
    /**
     * Get EditorialStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return isset($this->EditorialStatus) ? $this->EditorialStatus : null;
    }
    /**
     * Set EditorialStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupCriterionEditorialStatus::valueIsValid()
     * @uses \EnumType\AdGroupCriterionEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdGroupCriterionEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupCriterionEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\AdGroupCriterionEditorialStatus::getValidValues())), __LINE__);
        }
        if (is_null($editorialStatus) || (is_array($editorialStatus) && empty($editorialStatus))) {
            unset($this->EditorialStatus);
        } else {
            $this->EditorialStatus = $editorialStatus;
        }
        return $this;
    }
    /**
     * Get FinalAppUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAppUrl|null
     */
    public function getFinalAppUrls()
    {
        return isset($this->FinalAppUrls) ? $this->FinalAppUrls : null;
    }
    /**
     * Set FinalAppUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setFinalAppUrls(\ArrayType\ArrayOfAppUrl $finalAppUrls = null)
    {
        if (is_null($finalAppUrls) || (is_array($finalAppUrls) && empty($finalAppUrls))) {
            unset($this->FinalAppUrls);
        } else {
            $this->FinalAppUrls = $finalAppUrls;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
    /**
     * Get CriterionCashback value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CriterionCashback|null
     */
    public function getCriterionCashback()
    {
        return isset($this->CriterionCashback) ? $this->CriterionCashback : null;
    }
    /**
     * Set CriterionCashback value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CriterionCashback $criterionCashback
     * @return \StructType\BiddableAdGroupCriterion
     */
    public function setCriterionCashback(\StructType\CriterionCashback $criterionCashback = null)
    {
        if (is_null($criterionCashback) || (is_array($criterionCashback) && empty($criterionCashback))) {
            unset($this->CriterionCashback);
        } else {
            $this->CriterionCashback = $criterionCashback;
        }
        return $this;
    }
}
