<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidStrategy StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BidStrategy
 * @subpackage Structs
 */
class BidStrategy extends AbstractStructBase
{
    /**
     * The AssociatedCampaignType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AssociatedCampaignType;
    /**
     * The AssociationCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AssociationCount;
    /**
     * The BiddingScheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BiddingScheme
     */
    public $BiddingScheme;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for BidStrategy
     * @uses BidStrategy::setAssociatedCampaignType()
     * @uses BidStrategy::setAssociationCount()
     * @uses BidStrategy::setBiddingScheme()
     * @uses BidStrategy::setId()
     * @uses BidStrategy::setName()
     * @param string[] $associatedCampaignType
     * @param int $associationCount
     * @param \StructType\BiddingScheme $biddingScheme
     * @param int $id
     * @param string $name
     */
    public function __construct(array $associatedCampaignType = array(), $associationCount = null, \StructType\BiddingScheme $biddingScheme = null, $id = null, $name = null)
    {
        $this
            ->setAssociatedCampaignType($associatedCampaignType)
            ->setAssociationCount($associationCount)
            ->setBiddingScheme($biddingScheme)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get AssociatedCampaignType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAssociatedCampaignType()
    {
        return isset($this->AssociatedCampaignType) ? $this->AssociatedCampaignType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociatedCampaignType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedCampaignType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociatedCampaignTypeForArrayConstraintsFromSetAssociatedCampaignType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bidStrategyAssociatedCampaignTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignType::valueIsValid($bidStrategyAssociatedCampaignTypeItem)) {
                $invalidValues[] = is_object($bidStrategyAssociatedCampaignTypeItem) ? get_class($bidStrategyAssociatedCampaignTypeItem) : sprintf('%s(%s)', gettype($bidStrategyAssociatedCampaignTypeItem), var_export($bidStrategyAssociatedCampaignTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssociatedCampaignType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignType::valueIsValid()
     * @uses \EnumType\CampaignType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $associatedCampaignType
     * @return \StructType\BidStrategy
     */
    public function setAssociatedCampaignType(array $associatedCampaignType = array())
    {
        // validation for constraint: list
        if ('' !== ($associatedCampaignTypeArrayErrorMessage = self::validateAssociatedCampaignTypeForArrayConstraintsFromSetAssociatedCampaignType($associatedCampaignType))) {
            throw new \InvalidArgumentException($associatedCampaignTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($associatedCampaignType) || (is_array($associatedCampaignType) && empty($associatedCampaignType))) {
            unset($this->AssociatedCampaignType);
        } else {
            $this->AssociatedCampaignType = is_array($associatedCampaignType) ? implode(' ', $associatedCampaignType) : null;
        }
        return $this;
    }
    /**
     * Get AssociationCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAssociationCount()
    {
        return isset($this->AssociationCount) ? $this->AssociationCount : null;
    }
    /**
     * Set AssociationCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $associationCount
     * @return \StructType\BidStrategy
     */
    public function setAssociationCount($associationCount = null)
    {
        // validation for constraint: int
        if (!is_null($associationCount) && !(is_int($associationCount) || ctype_digit($associationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associationCount, true), gettype($associationCount)), __LINE__);
        }
        if (is_null($associationCount) || (is_array($associationCount) && empty($associationCount))) {
            unset($this->AssociationCount);
        } else {
            $this->AssociationCount = $associationCount;
        }
        return $this;
    }
    /**
     * Get BiddingScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BiddingScheme|null
     */
    public function getBiddingScheme()
    {
        return isset($this->BiddingScheme) ? $this->BiddingScheme : null;
    }
    /**
     * Set BiddingScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BiddingScheme $biddingScheme
     * @return \StructType\BidStrategy
     */
    public function setBiddingScheme(\StructType\BiddingScheme $biddingScheme = null)
    {
        if (is_null($biddingScheme) || (is_array($biddingScheme) && empty($biddingScheme))) {
            unset($this->BiddingScheme);
        } else {
            $this->BiddingScheme = $biddingScheme;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\BidStrategy
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\BidStrategy
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
