<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchErrorCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchErrorCollection
 * @subpackage Structs
 */
class BatchErrorCollection extends AbstractStructBase
{
    /**
     * The BatchErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $BatchErrors;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Code;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The FieldPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldPath;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Index;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for BatchErrorCollection
     * @uses BatchErrorCollection::setBatchErrors()
     * @uses BatchErrorCollection::setCode()
     * @uses BatchErrorCollection::setDetails()
     * @uses BatchErrorCollection::setErrorCode()
     * @uses BatchErrorCollection::setFieldPath()
     * @uses BatchErrorCollection::setForwardCompatibilityMap()
     * @uses BatchErrorCollection::setIndex()
     * @uses BatchErrorCollection::setMessage()
     * @uses BatchErrorCollection::setType()
     * @param \ArrayType\ArrayOfBatchError $batchErrors
     * @param int $code
     * @param string $details
     * @param string $errorCode
     * @param string $fieldPath
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $index
     * @param string $message
     * @param string $type
     */
    public function __construct(\ArrayType\ArrayOfBatchError $batchErrors = null, $code = null, $details = null, $errorCode = null, $fieldPath = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $index = null, $message = null, $type = null)
    {
        $this
            ->setBatchErrors($batchErrors)
            ->setCode($code)
            ->setDetails($details)
            ->setErrorCode($errorCode)
            ->setFieldPath($fieldPath)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setIndex($index)
            ->setMessage($message)
            ->setType($type);
    }
    /**
     * Get BatchErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getBatchErrors()
    {
        return isset($this->BatchErrors) ? $this->BatchErrors : null;
    }
    /**
     * Set BatchErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $batchErrors
     * @return \StructType\BatchErrorCollection
     */
    public function setBatchErrors(\ArrayType\ArrayOfBatchError $batchErrors = null)
    {
        if (is_null($batchErrors) || (is_array($batchErrors) && empty($batchErrors))) {
            unset($this->BatchErrors);
        } else {
            $this->BatchErrors = $batchErrors;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code
     * @return \StructType\BatchErrorCollection
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \StructType\BatchErrorCollection
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\BatchErrorCollection
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get FieldPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldPath()
    {
        return isset($this->FieldPath) ? $this->FieldPath : null;
    }
    /**
     * Set FieldPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldPath
     * @return \StructType\BatchErrorCollection
     */
    public function setFieldPath($fieldPath = null)
    {
        // validation for constraint: string
        if (!is_null($fieldPath) && !is_string($fieldPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldPath, true), gettype($fieldPath)), __LINE__);
        }
        if (is_null($fieldPath) || (is_array($fieldPath) && empty($fieldPath))) {
            unset($this->FieldPath);
        } else {
            $this->FieldPath = $fieldPath;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\BatchErrorCollection
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \StructType\BatchErrorCollection
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\BatchErrorCollection
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\BatchErrorCollection
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
