<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BMCStore StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BMCStore
 * @subpackage Structs
 */
class BMCStore extends AbstractStructBase
{
    /**
     * The HasCatalog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasCatalog;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsProductAdsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsProductAdsEnabled;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * Constructor method for BMCStore
     * @uses BMCStore::setHasCatalog()
     * @uses BMCStore::setId()
     * @uses BMCStore::setIsActive()
     * @uses BMCStore::setIsProductAdsEnabled()
     * @uses BMCStore::setName()
     * @uses BMCStore::setSubType()
     * @param bool $hasCatalog
     * @param int $id
     * @param bool $isActive
     * @param bool $isProductAdsEnabled
     * @param string $name
     * @param string $subType
     */
    public function __construct($hasCatalog = null, $id = null, $isActive = null, $isProductAdsEnabled = null, $name = null, $subType = null)
    {
        $this
            ->setHasCatalog($hasCatalog)
            ->setId($id)
            ->setIsActive($isActive)
            ->setIsProductAdsEnabled($isProductAdsEnabled)
            ->setName($name)
            ->setSubType($subType);
    }
    /**
     * Get HasCatalog value
     * @return bool|null
     */
    public function getHasCatalog()
    {
        return $this->HasCatalog;
    }
    /**
     * Set HasCatalog value
     * @param bool $hasCatalog
     * @return \StructType\BMCStore
     */
    public function setHasCatalog($hasCatalog = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasCatalog) && !is_bool($hasCatalog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasCatalog, true), gettype($hasCatalog)), __LINE__);
        }
        $this->HasCatalog = $hasCatalog;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\BMCStore
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\BMCStore
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsProductAdsEnabled value
     * @return bool|null
     */
    public function getIsProductAdsEnabled()
    {
        return $this->IsProductAdsEnabled;
    }
    /**
     * Set IsProductAdsEnabled value
     * @param bool $isProductAdsEnabled
     * @return \StructType\BMCStore
     */
    public function setIsProductAdsEnabled($isProductAdsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductAdsEnabled) && !is_bool($isProductAdsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductAdsEnabled, true), gettype($isProductAdsEnabled)), __LINE__);
        }
        $this->IsProductAdsEnabled = $isProductAdsEnabled;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\BMCStore
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BMCStoreSubType::valueIsValid()
     * @uses \EnumType\BMCStoreSubType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subType
     * @return \StructType\BMCStore
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BMCStoreSubType::valueIsValid($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BMCStoreSubType', is_array($subType) ? implode(', ', $subType) : var_export($subType, true), implode(', ', \EnumType\BMCStoreSubType::getValidValues())), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
}
