<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The ProvinceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvinceCode;
    /**
     * The ProvinceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvinceName;
    /**
     * The StreetAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress;
    /**
     * The StreetAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress2;
    /**
     * Constructor method for Address
     * @uses Address::setCityName()
     * @uses Address::setCountryCode()
     * @uses Address::setPostalCode()
     * @uses Address::setProvinceCode()
     * @uses Address::setProvinceName()
     * @uses Address::setStreetAddress()
     * @uses Address::setStreetAddress2()
     * @param string $cityName
     * @param string $countryCode
     * @param string $postalCode
     * @param string $provinceCode
     * @param string $provinceName
     * @param string $streetAddress
     * @param string $streetAddress2
     */
    public function __construct($cityName = null, $countryCode = null, $postalCode = null, $provinceCode = null, $provinceName = null, $streetAddress = null, $streetAddress2 = null)
    {
        $this
            ->setCityName($cityName)
            ->setCountryCode($countryCode)
            ->setPostalCode($postalCode)
            ->setProvinceCode($provinceCode)
            ->setProvinceName($provinceName)
            ->setStreetAddress($streetAddress)
            ->setStreetAddress2($streetAddress2);
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \StructType\Address
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \StructType\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get ProvinceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvinceCode()
    {
        return isset($this->ProvinceCode) ? $this->ProvinceCode : null;
    }
    /**
     * Set ProvinceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provinceCode
     * @return \StructType\Address
     */
    public function setProvinceCode($provinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($provinceCode) && !is_string($provinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinceCode, true), gettype($provinceCode)), __LINE__);
        }
        if (is_null($provinceCode) || (is_array($provinceCode) && empty($provinceCode))) {
            unset($this->ProvinceCode);
        } else {
            $this->ProvinceCode = $provinceCode;
        }
        return $this;
    }
    /**
     * Get ProvinceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvinceName()
    {
        return isset($this->ProvinceName) ? $this->ProvinceName : null;
    }
    /**
     * Set ProvinceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provinceName
     * @return \StructType\Address
     */
    public function setProvinceName($provinceName = null)
    {
        // validation for constraint: string
        if (!is_null($provinceName) && !is_string($provinceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinceName, true), gettype($provinceName)), __LINE__);
        }
        if (is_null($provinceName) || (is_array($provinceName) && empty($provinceName))) {
            unset($this->ProvinceName);
        } else {
            $this->ProvinceName = $provinceName;
        }
        return $this;
    }
    /**
     * Get StreetAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress()
    {
        return isset($this->StreetAddress) ? $this->StreetAddress : null;
    }
    /**
     * Set StreetAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress
     * @return \StructType\Address
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress, true), gettype($streetAddress)), __LINE__);
        }
        if (is_null($streetAddress) || (is_array($streetAddress) && empty($streetAddress))) {
            unset($this->StreetAddress);
        } else {
            $this->StreetAddress = $streetAddress;
        }
        return $this;
    }
    /**
     * Get StreetAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress2()
    {
        return isset($this->StreetAddress2) ? $this->StreetAddress2 : null;
    }
    /**
     * Set StreetAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress2
     * @return \StructType\Address
     */
    public function setStreetAddress2($streetAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress2) && !is_string($streetAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress2, true), gettype($streetAddress2)), __LINE__);
        }
        if (is_null($streetAddress2) || (is_array($streetAddress2) && empty($streetAddress2))) {
            unset($this->StreetAddress2);
        } else {
            $this->StreetAddress2 = $streetAddress2;
        }
        return $this;
    }
}
