<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddVideosResponse StructType
 * @subpackage Structs
 */
class AddVideosResponse extends AbstractStructBase
{
    /**
     * The VideoIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $VideoIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddVideosResponse
     * @uses AddVideosResponse::setVideoIds()
     * @uses AddVideosResponse::setPartialErrors()
     * @param \ArrayType\ArrayOflong $videoIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOflong $videoIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setVideoIds($videoIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get VideoIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getVideoIds()
    {
        return isset($this->VideoIds) ? $this->VideoIds : null;
    }
    /**
     * Set VideoIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $videoIds
     * @return \StructType\AddVideosResponse
     */
    public function setVideoIds(\ArrayType\ArrayOflong $videoIds = null)
    {
        if (is_null($videoIds) || (is_array($videoIds) && empty($videoIds))) {
            unset($this->VideoIds);
        } else {
            $this->VideoIds = $videoIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddVideosResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
