<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddVideosRequest StructType
 * @subpackage Structs
 */
class AddVideosRequest extends AbstractStructBase
{
    /**
     * The Videos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVideo
     */
    public $Videos;
    /**
     * Constructor method for AddVideosRequest
     * @uses AddVideosRequest::setVideos()
     * @param \ArrayType\ArrayOfVideo $videos
     */
    public function __construct(\ArrayType\ArrayOfVideo $videos = null)
    {
        $this
            ->setVideos($videos);
    }
    /**
     * Get Videos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVideo|null
     */
    public function getVideos()
    {
        return isset($this->Videos) ? $this->Videos : null;
    }
    /**
     * Set Videos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVideo $videos
     * @return \StructType\AddVideosRequest
     */
    public function setVideos(\ArrayType\ArrayOfVideo $videos = null)
    {
        if (is_null($videos) || (is_array($videos) && empty($videos))) {
            unset($this->Videos);
        } else {
            $this->Videos = $videos;
        }
        return $this;
    }
}
