<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddSharedEntityRequest StructType
 * @subpackage Structs
 */
class AddSharedEntityRequest extends AbstractStructBase
{
    /**
     * The SharedEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SharedEntity
     */
    public $SharedEntity;
    /**
     * The ListItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSharedListItem
     */
    public $ListItems;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for AddSharedEntityRequest
     * @uses AddSharedEntityRequest::setSharedEntity()
     * @uses AddSharedEntityRequest::setListItems()
     * @uses AddSharedEntityRequest::setSharedEntityScope()
     * @param \StructType\SharedEntity $sharedEntity
     * @param \ArrayType\ArrayOfSharedListItem $listItems
     * @param string $sharedEntityScope
     */
    public function __construct(\StructType\SharedEntity $sharedEntity = null, \ArrayType\ArrayOfSharedListItem $listItems = null, $sharedEntityScope = null)
    {
        $this
            ->setSharedEntity($sharedEntity)
            ->setListItems($listItems)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get SharedEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SharedEntity|null
     */
    public function getSharedEntity()
    {
        return isset($this->SharedEntity) ? $this->SharedEntity : null;
    }
    /**
     * Set SharedEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SharedEntity $sharedEntity
     * @return \StructType\AddSharedEntityRequest
     */
    public function setSharedEntity(\StructType\SharedEntity $sharedEntity = null)
    {
        if (is_null($sharedEntity) || (is_array($sharedEntity) && empty($sharedEntity))) {
            unset($this->SharedEntity);
        } else {
            $this->SharedEntity = $sharedEntity;
        }
        return $this;
    }
    /**
     * Get ListItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSharedListItem|null
     */
    public function getListItems()
    {
        return isset($this->ListItems) ? $this->ListItems : null;
    }
    /**
     * Set ListItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSharedListItem $listItems
     * @return \StructType\AddSharedEntityRequest
     */
    public function setListItems(\ArrayType\ArrayOfSharedListItem $listItems = null)
    {
        if (is_null($listItems) || (is_array($listItems) && empty($listItems))) {
            unset($this->ListItems);
        } else {
            $this->ListItems = $listItems;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\AddSharedEntityRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
