<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMediaResponse StructType
 * @subpackage Structs
 */
class AddMediaResponse extends AbstractStructBase
{
    /**
     * The MediaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $MediaIds;
    /**
     * Constructor method for AddMediaResponse
     * @uses AddMediaResponse::setMediaIds()
     * @param \ArrayType\ArrayOflong $mediaIds
     */
    public function __construct(\ArrayType\ArrayOflong $mediaIds = null)
    {
        $this
            ->setMediaIds($mediaIds);
    }
    /**
     * Get MediaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getMediaIds()
    {
        return isset($this->MediaIds) ? $this->MediaIds : null;
    }
    /**
     * Set MediaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $mediaIds
     * @return \StructType\AddMediaResponse
     */
    public function setMediaIds(\ArrayType\ArrayOflong $mediaIds = null)
    {
        if (is_null($mediaIds) || (is_array($mediaIds) && empty($mediaIds))) {
            unset($this->MediaIds);
        } else {
            $this->MediaIds = $mediaIds;
        }
        return $this;
    }
}
