<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExperimentsResponse StructType
 * @subpackage Structs
 */
class AddExperimentsResponse extends AbstractStructBase
{
    /**
     * The ExperimentIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $ExperimentIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddExperimentsResponse
     * @uses AddExperimentsResponse::setExperimentIds()
     * @uses AddExperimentsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $experimentIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $experimentIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setExperimentIds($experimentIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ExperimentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getExperimentIds()
    {
        return isset($this->ExperimentIds) ? $this->ExperimentIds : null;
    }
    /**
     * Set ExperimentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $experimentIds
     * @return \StructType\AddExperimentsResponse
     */
    public function setExperimentIds(\ArrayType\ArrayOfNullableOflong $experimentIds = null)
    {
        if (is_null($experimentIds) || (is_array($experimentIds) && empty($experimentIds))) {
            unset($this->ExperimentIds);
        } else {
            $this->ExperimentIds = $experimentIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddExperimentsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
