<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExperimentsRequest StructType
 * @subpackage Structs
 */
class AddExperimentsRequest extends AbstractStructBase
{
    /**
     * The Experiments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfExperiment
     */
    public $Experiments;
    /**
     * Constructor method for AddExperimentsRequest
     * @uses AddExperimentsRequest::setExperiments()
     * @param \ArrayType\ArrayOfExperiment $experiments
     */
    public function __construct(\ArrayType\ArrayOfExperiment $experiments = null)
    {
        $this
            ->setExperiments($experiments);
    }
    /**
     * Get Experiments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfExperiment|null
     */
    public function getExperiments()
    {
        return isset($this->Experiments) ? $this->Experiments : null;
    }
    /**
     * Set Experiments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfExperiment $experiments
     * @return \StructType\AddExperimentsRequest
     */
    public function setExperiments(\ArrayType\ArrayOfExperiment $experiments = null)
    {
        if (is_null($experiments) || (is_array($experiments) && empty($experiments))) {
            unset($this->Experiments);
        } else {
            $this->Experiments = $experiments;
        }
        return $this;
    }
}
