<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddConversionGoalsResponse StructType
 * @subpackage Structs
 */
class AddConversionGoalsResponse extends AbstractStructBase
{
    /**
     * The ConversionGoalIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $ConversionGoalIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddConversionGoalsResponse
     * @uses AddConversionGoalsResponse::setConversionGoalIds()
     * @uses AddConversionGoalsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $conversionGoalIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $conversionGoalIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setConversionGoalIds($conversionGoalIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ConversionGoalIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getConversionGoalIds()
    {
        return isset($this->ConversionGoalIds) ? $this->ConversionGoalIds : null;
    }
    /**
     * Set ConversionGoalIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $conversionGoalIds
     * @return \StructType\AddConversionGoalsResponse
     */
    public function setConversionGoalIds(\ArrayType\ArrayOfNullableOflong $conversionGoalIds = null)
    {
        if (is_null($conversionGoalIds) || (is_array($conversionGoalIds) && empty($conversionGoalIds))) {
            unset($this->ConversionGoalIds);
        } else {
            $this->ConversionGoalIds = $conversionGoalIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddConversionGoalsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
