<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCampaignsResponse StructType
 * @subpackage Structs
 */
class AddCampaignsResponse extends AbstractStructBase
{
    /**
     * The CampaignIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $CampaignIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddCampaignsResponse
     * @uses AddCampaignsResponse::setCampaignIds()
     * @uses AddCampaignsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $campaignIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $campaignIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setCampaignIds($campaignIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get CampaignIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getCampaignIds()
    {
        return isset($this->CampaignIds) ? $this->CampaignIds : null;
    }
    /**
     * Set CampaignIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $campaignIds
     * @return \StructType\AddCampaignsResponse
     */
    public function setCampaignIds(\ArrayType\ArrayOfNullableOflong $campaignIds = null)
    {
        if (is_null($campaignIds) || (is_array($campaignIds) && empty($campaignIds))) {
            unset($this->CampaignIds);
        } else {
            $this->CampaignIds = $campaignIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddCampaignsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
