<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCampaignCriterionsResponse StructType
 * @subpackage Structs
 */
class AddCampaignCriterionsResponse extends AbstractStructBase
{
    /**
     * The CampaignCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $CampaignCriterionIds;
    /**
     * The NestedPartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchErrorCollection
     */
    public $NestedPartialErrors;
    /**
     * Constructor method for AddCampaignCriterionsResponse
     * @uses AddCampaignCriterionsResponse::setCampaignCriterionIds()
     * @uses AddCampaignCriterionsResponse::setNestedPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $campaignCriterionIds
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $campaignCriterionIds = null, \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        $this
            ->setCampaignCriterionIds($campaignCriterionIds)
            ->setNestedPartialErrors($nestedPartialErrors);
    }
    /**
     * Get CampaignCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getCampaignCriterionIds()
    {
        return isset($this->CampaignCriterionIds) ? $this->CampaignCriterionIds : null;
    }
    /**
     * Set CampaignCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $campaignCriterionIds
     * @return \StructType\AddCampaignCriterionsResponse
     */
    public function setCampaignCriterionIds(\ArrayType\ArrayOfNullableOflong $campaignCriterionIds = null)
    {
        if (is_null($campaignCriterionIds) || (is_array($campaignCriterionIds) && empty($campaignCriterionIds))) {
            unset($this->CampaignCriterionIds);
        } else {
            $this->CampaignCriterionIds = $campaignCriterionIds;
        }
        return $this;
    }
    /**
     * Get NestedPartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchErrorCollection|null
     */
    public function getNestedPartialErrors()
    {
        return isset($this->NestedPartialErrors) ? $this->NestedPartialErrors : null;
    }
    /**
     * Set NestedPartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     * @return \StructType\AddCampaignCriterionsResponse
     */
    public function setNestedPartialErrors(\ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        if (is_null($nestedPartialErrors) || (is_array($nestedPartialErrors) && empty($nestedPartialErrors))) {
            unset($this->NestedPartialErrors);
        } else {
            $this->NestedPartialErrors = $nestedPartialErrors;
        }
        return $this;
    }
}
