<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAudiencesResponse StructType
 * @subpackage Structs
 */
class AddAudiencesResponse extends AbstractStructBase
{
    /**
     * The AudienceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $AudienceIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddAudiencesResponse
     * @uses AddAudiencesResponse::setAudienceIds()
     * @uses AddAudiencesResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $audienceIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $audienceIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAudienceIds($audienceIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AudienceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getAudienceIds()
    {
        return isset($this->AudienceIds) ? $this->AudienceIds : null;
    }
    /**
     * Set AudienceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $audienceIds
     * @return \StructType\AddAudiencesResponse
     */
    public function setAudienceIds(\ArrayType\ArrayOfNullableOflong $audienceIds = null)
    {
        if (is_null($audienceIds) || (is_array($audienceIds) && empty($audienceIds))) {
            unset($this->AudienceIds);
        } else {
            $this->AudienceIds = $audienceIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddAudiencesResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
