<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdsResponse StructType
 * @subpackage Structs
 */
class AddAdsResponse extends AbstractStructBase
{
    /**
     * The AdIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $AdIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddAdsResponse
     * @uses AddAdsResponse::setAdIds()
     * @uses AddAdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $adIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $adIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdIds($adIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getAdIds()
    {
        return isset($this->AdIds) ? $this->AdIds : null;
    }
    /**
     * Set AdIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $adIds
     * @return \StructType\AddAdsResponse
     */
    public function setAdIds(\ArrayType\ArrayOfNullableOflong $adIds = null)
    {
        if (is_null($adIds) || (is_array($adIds) && empty($adIds))) {
            unset($this->AdIds);
        } else {
            $this->AdIds = $adIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddAdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
