<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdsRequest StructType
 * @subpackage Structs
 */
class AddAdsRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The Ads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAd
     */
    public $Ads;
    /**
     * Constructor method for AddAdsRequest
     * @uses AddAdsRequest::setAdGroupId()
     * @uses AddAdsRequest::setAds()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOfAd $ads
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOfAd $ads = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setAds($ads);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\AddAdsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get Ads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAd|null
     */
    public function getAds()
    {
        return isset($this->Ads) ? $this->Ads : null;
    }
    /**
     * Set Ads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAd $ads
     * @return \StructType\AddAdsRequest
     */
    public function setAds(\ArrayType\ArrayOfAd $ads = null)
    {
        if (is_null($ads) || (is_array($ads) && empty($ads))) {
            unset($this->Ads);
        } else {
            $this->Ads = $ads;
        }
        return $this;
    }
}
